/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.client.api;

import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.List;

public final class Plugin {
    private final String key;
    private final String version;
    private final String newestVersion;
    private final URI content;
    private final List<Unresolved> unresolved;

    public boolean isCompatible() {
        return this.unresolved.isEmpty();
    }

    @ConstructorProperties(value={"key", "version", "newestVersion", "content", "unresolved"})
    public Plugin(String key, String version, String newestVersion, URI content, List<Unresolved> unresolved) {
        this.key = key;
        this.version = version;
        this.newestVersion = newestVersion;
        this.content = content;
        this.unresolved = unresolved;
    }

    public String getKey() {
        return this.key;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNewestVersion() {
        return this.newestVersion;
    }

    public URI getContent() {
        return this.content;
    }

    public List<Unresolved> getUnresolved() {
        return this.unresolved;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plugin)) {
            return false;
        }
        Plugin other = (Plugin)o;
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$newestVersion = this.getNewestVersion();
        String other$newestVersion = other.getNewestVersion();
        if (this$newestVersion == null ? other$newestVersion != null : !this$newestVersion.equals(other$newestVersion)) {
            return false;
        }
        URI this$content = this.getContent();
        URI other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        List<Unresolved> this$unresolved = this.getUnresolved();
        List<Unresolved> other$unresolved = other.getUnresolved();
        return !(this$unresolved == null ? other$unresolved != null : !((Object)this$unresolved).equals(other$unresolved));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $newestVersion = this.getNewestVersion();
        result = result * 59 + ($newestVersion == null ? 43 : $newestVersion.hashCode());
        URI $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        List<Unresolved> $unresolved = this.getUnresolved();
        result = result * 59 + ($unresolved == null ? 43 : ((Object)$unresolved).hashCode());
        return result;
    }

    public String toString() {
        return "Plugin(key=" + this.getKey() + ", version=" + this.getVersion() + ", newestVersion=" + this.getNewestVersion() + ", content=" + this.getContent() + ", unresolved=" + this.getUnresolved() + ")";
    }

    public Plugin withKey(String key) {
        return this.key == key ? this : new Plugin(key, this.version, this.newestVersion, this.content, this.unresolved);
    }

    public Plugin withVersion(String version) {
        return this.version == version ? this : new Plugin(this.key, version, this.newestVersion, this.content, this.unresolved);
    }

    public Plugin withNewestVersion(String newestVersion) {
        return this.newestVersion == newestVersion ? this : new Plugin(this.key, this.version, newestVersion, this.content, this.unresolved);
    }

    public Plugin withContent(URI content) {
        return this.content == content ? this : new Plugin(this.key, this.version, this.newestVersion, content, this.unresolved);
    }

    public Plugin withUnresolved(List<Unresolved> unresolved) {
        return this.unresolved == unresolved ? this : new Plugin(this.key, this.version, this.newestVersion, this.content, unresolved);
    }

    public static final class Unresolved {
        private final String key;
        private final String version;
        private final boolean mandatory;
        private final Error error;

        @ConstructorProperties(value={"key", "version", "mandatory", "error"})
        public Unresolved(String key, String version, boolean mandatory, Error error) {
            this.key = key;
            this.version = version;
            this.mandatory = mandatory;
            this.error = error;
        }

        public String getKey() {
            return this.key;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public Error getError() {
            return this.error;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unresolved)) {
                return false;
            }
            Unresolved other = (Unresolved)o;
            if (this.isMandatory() != other.isMandatory()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            Error this$error = this.getError();
            Error other$error = other.getError();
            return !(this$error == null ? other$error != null : !((Object)((Object)this$error)).equals((Object)other$error));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMandatory() ? 79 : 97);
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            Error $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)((Object)$error)).hashCode());
            return result;
        }

        public String toString() {
            return "Plugin.Unresolved(key=" + this.getKey() + ", version=" + this.getVersion() + ", mandatory=" + this.isMandatory() + ", error=" + (Object)((Object)this.getError()) + ")";
        }

        public static enum Error {
            MISSING,
            VERSION_MISMATCH;

        }
    }
}

