/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.client.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.autoupdate.server.client.api.Api;
import com.suncode.autoupdate.server.client.api.ApiException;
import com.suncode.autoupdate.server.client.api.EventData;
import com.suncode.autoupdate.server.client.api.EventsEndpoint;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class Events
extends Api<EventsEndpoint> {
    private static final Logger log = LoggerFactory.getLogger(Events.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Events(Retrofit retrofit) {
        super(EventsEndpoint.class, retrofit);
    }

    public void updateSuccess(UUID patch, EventData eventData) {
        this.send(((EventsEndpoint)this.endpoint).updateSuccess(patch, this.serialize(eventData)));
    }

    public void updateError(UUID patch, EventData eventData) {
        this.send(((EventsEndpoint)this.endpoint).updateError(patch, this.serialize(eventData)));
    }

    public void rollbackSuccess(UUID patch, EventData eventData) {
        this.send(((EventsEndpoint)this.endpoint).rollbackSuccess(patch, this.serialize(eventData)));
    }

    public void rollbackError(UUID patch, EventData eventData) {
        this.send(((EventsEndpoint)this.endpoint).rollbackError(patch, this.serialize(eventData)));
    }

    private String serialize(EventData eventData) {
        return this.objectMapper.writeValueAsString((Object)eventData);
    }

    private void send(Call<Void> call) {
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw new ApiException("Failed to send event", response);
        }
    }
}

