package com.suncode.autoupdate.server.client.api;

import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface UpdatesEndpoint
{
    @GET( "updates/{project}/{channel}" )
    Call<AvailablePatches> checkAll( @Path( "project" ) String project, @Path( "channel" ) String channel,
                                     @Query( "version" ) String version );

    @GET( "updates/{project}/{channel}/check" )
    Call<AvailableUpdates> checkNewest( @Path( "project" ) String project, @Path( "channel" ) String channel,
                                        @Query( "version" ) String version );
}
