package com.suncode.autoupdate.server.client.api;

import lombok.SneakyThrows;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

import java.util.function.Supplier;

public class Updates
    extends Api<UpdatesEndpoint>
{
    public Updates( Retrofit retrofit )
    {
        super( UpdatesEndpoint.class, retrofit );
    }

    @SneakyThrows
    public AvailablePatches checkAll( String project, String channel, String version )
    {
        return call(() -> endpoint.checkAll( project, channel, version ));
    }

    @SneakyThrows
    public AvailableUpdates checkNewest( String project, String channel, String version )
    {
        return call(() -> endpoint.checkNewest( project, channel, version ));
    }

    @SneakyThrows
    private <T> T call(Supplier<Call<T>> call) {
        Response<T> updates = call.get().execute();
        if ( !updates.isSuccessful() )
        {
            throw new RuntimeException( "Error retrieving available updates from " + updates.raw().request().url()
                    + " [STATUS_CODE: " + updates.code() + "]" + "::" + updates.errorBody().string() );
        }
        return updates.body();
    }


}
