package com.suncode.autoupdate.server.client.api;

import retrofit2.Call;
import retrofit2.http.*;

import java.util.List;

import static com.google.common.net.HttpHeaders.ACCEPT_LANGUAGE;

interface StoreEndpoint {
    @GET("store")
    Call<List<Product>> list();

    @GET("store")
    Call<List<Product>> list(@Header(ACCEPT_LANGUAGE) String languageCode);

    @POST("store/plugins/{pluginId}")
    Call<Plugin> get(@Path("pluginId") ProjectId id, @Body StoreCriteria.ClientCapabilities capabilities);

    @Deprecated
    @POST("store/plugins")
    @Streaming
    Call<List<Plugin>> getPlugins(@Body StoreCriteria request);
}
