package com.suncode.autoupdate.server.client.api;

import lombok.SneakyThrows;
import retrofit2.Response;
import retrofit2.Retrofit;

import java.util.List;
import java.util.Locale;

import static java.util.Locale.ENGLISH;
import static java.util.stream.Collectors.toList;

public class Store
        extends Api<StoreEndpoint> {
    public Store(Retrofit retrofit) {
        super(StoreEndpoint.class, retrofit);
    }

    @SneakyThrows
    public List<Product> list() {
        return list(ENGLISH);
    }

    @SneakyThrows
    public List<Product> list(Locale locale) {
        Response<List<Product>> products = endpoint.list(locale.toLanguageTag()).execute();
        if (!products.isSuccessful()) {
            throw new ApiException("Error retrieving plugins from store", products);
        }
        return products.body();
    }

    @SneakyThrows
    public StorePlugin download(ProjectId projectId, StoreCriteria.ClientCapabilities capabilities) {
        Response<Plugin> plugin = endpoint.get(projectId, capabilities).execute();
        if (!plugin.isSuccessful()) {
            throw new ApiException("Error retrieving plugin from store: " + projectId, plugin);
        }
        return new StorePlugin(
                plugin.body(),
                retrofit
        );
    }

    @SneakyThrows
    @Deprecated
    public List<StorePlugin> getPlugins(StoreCriteria request) {
        Response<List<Plugin>> plugins = endpoint.getPlugins(request).execute();
        if (!plugins.isSuccessful()) {
            throw new ApiException("Error retrieving plugins from store", plugins);
        }
        return plugins.body()
                .stream()
                .map(plugin -> new StorePlugin(plugin, retrofit))
                .collect(toList());
    }

}
