package com.suncode.autoupdate.server.client.api;

import java.util.List;

import lombok.SneakyThrows;
import retrofit2.Response;
import retrofit2.Retrofit;

public class Projects
    extends Api<ProjectsEndpoint>
{
    public Projects( Retrofit retrofit )
    {
        super( ProjectsEndpoint.class, retrofit );
    }

    @SneakyThrows
    public List<Project> getProjects() {
        Response<List<Project>> projects = endpoint.getChannels().execute();
        if ( !projects.isSuccessful() )
        { 
            throw new RuntimeException( "Error retrieving projects from " + projects.raw().request().url()
                + " [STATUS_CODE: " + projects.code() + "]" + "::" + projects.errorBody().string() );
        }
        return projects.body();
    }
}
