package com.suncode.autoupdate.server.client.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;
import lombok.Value;

import static lombok.AccessLevel.NONE;

@Value
public class ProjectId {
    @Getter(NONE)
    String id;

    @JsonValue
    public String asString() {
        return id;
    }

    @JsonCreator
    public static ProjectId projectId(String id) {
        return new ProjectId(id);
    }

    @Override
    public String toString() {
        return asString();
    }
}
