package com.suncode.autoupdate.server.client.api;

import lombok.Value;
import lombok.experimental.Wither;

import java.net.URI;
import java.util.List;

@Value
@Wither
public class Plugin {
    String key;
    String version;
    String newestVersion;
    URI content;
    List<Unresolved> unresolved;

    public boolean isCompatible() {
        return unresolved.isEmpty();
    }

    @Value
    public static class Unresolved {
        String key;
        String version;
        boolean mandatory;

        Error error;

        public enum Error {
            MISSING,
            VERSION_MISMATCH
        }
    }
}
