package com.suncode.autoupdate.server.client.api;

import java.util.UUID;

import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface EventsEndpoint
{
    @FormUrlEncoded
    @POST( "events/update/success" )
    Call<Void> updateSuccess( @Query( "patchId" ) UUID patchId, @Field( "data" ) String data );

    @FormUrlEncoded
    @POST( "events/update/error" )
    Call<Void> updateError( @Query( "patchId" ) UUID patchId, @Field( "data" ) String data );

    @FormUrlEncoded
    @POST( "events/rollback/success" )
    Call<Void> rollbackSuccess( @Query( "patchId" ) UUID patchId, @Field( "data" ) String data );

    @FormUrlEncoded
    @POST( "events/rollback/error" )
    Call<Void> rollbackError( @Query( "patchId" ) UUID patchId, @Field( "data" ) String data );
}