package com.suncode.autoupdate.server.client.api;

import java.util.UUID;

import com.fasterxml.jackson.databind.ObjectMapper;

import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

@Slf4j
public class Events
        extends Api<EventsEndpoint> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Events(Retrofit retrofit) {
        super(EventsEndpoint.class, retrofit);
    }

    public void updateSuccess(UUID patch, EventData eventData) {
        send(endpoint.updateSuccess(patch, serialize(eventData)));
    }

    public void updateError(UUID patch, EventData eventData) {
        send(endpoint.updateError(patch, serialize(eventData)));
    }

    public void rollbackSuccess(UUID patch, EventData eventData) {
        send(endpoint.rollbackSuccess(patch, serialize(eventData)));
    }

    public void rollbackError(UUID patch, EventData eventData) {
        send(endpoint.rollbackError(patch, serialize(eventData)));
    }

    @SneakyThrows
    private String serialize(EventData eventData) {
        return objectMapper.writeValueAsString(eventData);
    }

    @SneakyThrows
    private void send(Call<Void> call) {
        Response<Void> response = call.execute();
        if (!response.isSuccessful()) {
            throw new ApiException("Failed to send event", response);
        }
    }
}
