package com.suncode.autoupdate.server.client.api;

import com.suncode.autoupdate.server.client.ApiToken;
import lombok.Data;
import lombok.ToString;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

@Data
@ToString(exclude = "apiToken")
public class Client
{
    public enum Type {
        TRIAL,
        STANDARD;
    }

    private String id;
    private String name;
    private Type type;
    private String apiToken;
    private Instant created;
    private List<String> environments = new ArrayList<String>();

    public ApiToken getApiToken() {
        return ApiToken.of(apiToken);
    }
}