package com.suncode.autoupdate.server.client.api;

import lombok.experimental.FieldDefaults;
import retrofit2.Retrofit;

import static lombok.AccessLevel.PACKAGE;

@FieldDefaults(level = PACKAGE, makeFinal = true)
abstract class Api<T>
{
    Retrofit retrofit;
    T endpoint;
    
    Api(Class<T> endpointClass, Retrofit retrofit)
    {
        this.retrofit = retrofit;
        this.endpoint = retrofit.create( endpointClass );
    }
}
