package com.suncode.autoupdate.server.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

import java.net.URI;
import java.util.concurrent.TimeUnit;

import static okhttp3.logging.HttpLoggingInterceptor.Level.BASIC;

@Slf4j
class RetrofitFactory
{
    public Retrofit create( URI base, Interceptor interceptor )
    {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(
                msg -> log.debug("UpdateServer{}", msg))
                .setLevel(BASIC);

        OkHttpClient client = client()
                        .addInterceptor( interceptor )
                        .addInterceptor(logging)
                        .connectTimeout( 1, TimeUnit.MINUTES)
                        .readTimeout( 30, TimeUnit.MINUTES )
                        .writeTimeout( 30, TimeUnit.MINUTES )
                        .build();
        return new Retrofit.Builder()
            .baseUrl( HttpUrl.get( base ) )
            .addConverterFactory( JacksonConverterFactory.create( new ObjectMapper()
                .configure( DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false ) ) )
            .client( client )
            .build();
    }

    @SneakyThrows
    private OkHttpClient.Builder client()
    {
        return new OkHttpClient.Builder();
    }
}
