/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.client.api;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.suncode.autoupdate.server.client.api.Api;
import com.suncode.autoupdate.server.client.api.Patch;
import com.suncode.autoupdate.server.client.api.PatchesEndpoint;
import com.suncode.autoupdate.server.client.util.GZipUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import retrofit2.Response;
import retrofit2.Retrofit;

public class Patches
extends Api<PatchesEndpoint> {
    public Patches(Retrofit retrofit) {
        super(PatchesEndpoint.class, retrofit);
    }

    public void download(Patch patch, final OutputStream out) throws IOException {
        this.download(patch, new PatchStreamConsumer(){

            @Override
            public void accept(InputStream in) throws IOException {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        });
    }

    public void download(Patch patch, PatchStreamConsumer out) throws IOException {
        Response archive = ((PatchesEndpoint)this.endpoint).download(patch.getId()).execute();
        if (archive.isSuccessful()) {
            try (HashingInputStream in = new HashingInputStream(Hashing.md5(), this.getUncompressed((Response<ResponseBody>)archive));){
                out.accept((InputStream)in);
                String checksum = in.hash().toString();
                if (!patch.getChecksum().equals(checksum)) {
                    throw new IOException(String.format("Patch [%s] checksum missmatch expected [%s] got [%s]", patch, patch.getChecksum(), checksum));
                }
            }
            return;
        }
        throw new IOException("Error downloading patch " + patch + ": " + archive.message() + " (" + archive.code() + ")");
    }

    private InputStream getUncompressed(Response<ResponseBody> archive) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(((ResponseBody)archive.body()).byteStream());
        if (GZipUtil.isGZipped(inputStream)) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static interface PatchStreamConsumer {
        public void accept(InputStream var1) throws IOException;
    }
}

