/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.client;

import com.suncode.autoupdate.server.client.ApiToken;
import com.suncode.autoupdate.server.client.Environment;
import com.suncode.autoupdate.server.client.Identity;
import com.suncode.autoupdate.server.client.RetrofitFactory;
import com.suncode.autoupdate.server.client.api.Events;
import com.suncode.autoupdate.server.client.api.Patches;
import com.suncode.autoupdate.server.client.api.Projects;
import com.suncode.autoupdate.server.client.api.Store;
import com.suncode.autoupdate.server.client.api.TrialRegistration;
import com.suncode.autoupdate.server.client.api.Updates;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Retrofit;

public class UpdateServerClient {
    private final ApiToken apiToken;
    private final Environment environment;
    private Retrofit retrofit;
    private Updates updates;
    private Patches patches;
    private Events events;
    private Projects projects;
    private TrialRegistration trialRegistration;
    private Store store;

    private UpdateServerClient(URI updateServerAddress, ApiToken apiToken, Environment environment) {
        URI target = Optional.ofNullable(updateServerAddress).orElseGet(() -> URI.create("https://www.aktualizacje.plusworkflow.pl"));
        this.apiToken = apiToken;
        this.environment = environment;
        this.retrofit = new RetrofitFactory().create(target, new AuthInterceptor());
        this.updates = new Updates(this.retrofit);
        this.patches = new Patches(this.retrofit);
        this.events = new Events(this.retrofit);
        this.projects = new Projects(this.retrofit);
        this.trialRegistration = new TrialRegistration(this.retrofit);
        this.store = new Store(this.retrofit);
    }

    public static UpdateServerClient create() {
        return UpdateServerClient.builder().build();
    }

    public static UpdateServerClient create(Identity identity) {
        return UpdateServerClient.builder().updateServerAddress(identity.getServiceUrl()).apiToken(identity.getApiToken()).environment(identity.getEnvironment()).build();
    }

    private static UpdateServerClient create(URI updateServerAddress, ApiToken apiToken, Environment environment) {
        return new UpdateServerClient(updateServerAddress, apiToken, environment);
    }

    public static UpdateServerClientBuilder builder() {
        return new UpdateServerClientBuilder();
    }

    public ApiToken apiToken() {
        return this.apiToken;
    }

    public Environment environment() {
        return this.environment;
    }

    public Retrofit retrofit() {
        return this.retrofit;
    }

    public Updates updates() {
        return this.updates;
    }

    public Patches patches() {
        return this.patches;
    }

    public Events events() {
        return this.events;
    }

    public Projects projects() {
        return this.projects;
    }

    public TrialRegistration trialRegistration() {
        return this.trialRegistration;
    }

    public Store store() {
        return this.store;
    }

    public static class UpdateServerClientBuilder {
        private URI updateServerAddress;
        private ApiToken apiToken;
        private Environment environment;

        UpdateServerClientBuilder() {
        }

        public UpdateServerClientBuilder updateServerAddress(URI updateServerAddress) {
            this.updateServerAddress = updateServerAddress;
            return this;
        }

        public UpdateServerClientBuilder apiToken(ApiToken apiToken) {
            this.apiToken = apiToken;
            return this;
        }

        public UpdateServerClientBuilder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public UpdateServerClient build() {
            return UpdateServerClient.create(this.updateServerAddress, this.apiToken, this.environment);
        }

        public String toString() {
            return "UpdateServerClient.UpdateServerClientBuilder(updateServerAddress=" + this.updateServerAddress + ", apiToken=" + this.apiToken + ", environment=" + this.environment + ")";
        }
    }

    private class AuthInterceptor
    implements Interceptor {
        private AuthInterceptor() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request.Builder request = chain.request().newBuilder();
            HttpUrl.Builder url = chain.request().url().newBuilder();
            if (UpdateServerClient.this.apiToken != null) {
                request.addHeader("X-Auth-Token", UpdateServerClient.this.apiToken.getToken());
            }
            if (UpdateServerClient.this.environment != null) {
                url.addQueryParameter("clientEnv", UpdateServerClient.this.environment.getEnv());
            }
            return chain.proceed(request.url(url.build()).build());
        }
    }
}

