/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

class RetrofitFactory {
    private static final Logger log = LoggerFactory.getLogger(RetrofitFactory.class);

    RetrofitFactory() {
    }

    public Retrofit create(URI base, Interceptor interceptor) {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(msg -> log.debug("UpdateServer{}", (Object)msg)).setLevel(HttpLoggingInterceptor.Level.BASIC);
        OkHttpClient client = this.client().addInterceptor(interceptor).addInterceptor((Interceptor)logging).connectTimeout(1L, TimeUnit.MINUTES).readTimeout(30L, TimeUnit.MINUTES).writeTimeout(30L, TimeUnit.MINUTES).build();
        return new Retrofit.Builder().baseUrl(HttpUrl.get((URI)base)).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false))).client(client).build();
    }

    private OkHttpClient.Builder client() {
        return new OkHttpClient.Builder();
    }
}

