/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patcher.step;

import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.suncode.autoupdate.patch.plusworkflow.ValidationResult;
import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patch.plusworkflow.archive.Checksum;
import com.suncode.autoupdate.patch.plusworkflow.archive.Index;
import com.suncode.autoupdate.patcher.Context;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;

public final class Validator {
    @NonNull
    private final Context context;
    private static String[] EXCLUDES = new String[]{".autoupdate", ".patcher/", "META-INF/maven/", "META-INF/MANIFEST.MF"};

    public ValidationResult validate(Archive patch) {
        File project = this.context.getRoot();
        final ValidationResult result = new ValidationResult();
        final Checksum md5 = patch.getChecksum();
        final Index index = patch.getIndex();
        final Path projectRoot = project.toPath();
        final ArrayList missing = Lists.newArrayList();
        for (String path : md5.getPaths()) {
            if (this.isExcluded(path)) continue;
            missing.add(path);
        }
        Files.walkFileTree(projectRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                HashCode actual;
                Path relative = projectRoot.relativize(file);
                String relativePath = FilenameUtils.normalize((String)relative.toString(), (boolean)true);
                missing.remove(relativePath);
                if (Validator.this.isExcluded(relativePath)) {
                    return FileVisitResult.CONTINUE;
                }
                if (!md5.getPaths().contains(relativePath)) {
                    result.getExtra().add(relativePath);
                    return FileVisitResult.CONTINUE;
                }
                HashCode expected = md5.get(relativePath);
                if (!expected.equals((Object)(actual = com.google.common.io.Files.asByteSource((File)file.toFile()).hash(Hashing.md5())))) {
                    if (index.isAdded(relativePath)) {
                        result.getChecksumAdded().add(relativePath);
                    } else if (index.isUpdated(relativePath)) {
                        result.getChecksumUpdated().add(relativePath);
                    } else if (index.isDeleted(relativePath)) {
                        result.getChecksumDeleted().add(relativePath);
                    } else {
                        result.getChecksum().add(relativePath);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        result.getMissing().addAll(missing);
        return result;
    }

    private boolean isExcluded(String path) {
        for (String exclude : EXCLUDES) {
            if (!path.startsWith(exclude)) continue;
            return true;
        }
        return false;
    }

    @ConstructorProperties(value={"context"})
    public Validator(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.context = context;
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Validator)) {
            return false;
        }
        Validator other = (Validator)o;
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    public String toString() {
        return "Validator(context=" + this.getContext() + ")";
    }
}

