/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patcher.step;

import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patch.plusworkflow.archive.Index;
import com.suncode.autoupdate.patcher.Context;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;

public final class ApplyStep {
    @NonNull
    private final Context context;

    public void applyPatch(Archive archive) throws IOException {
        Throwable throwable;
        InputStream input;
        File dest;
        Index index = archive.getIndex();
        File root = this.context.getRoot();
        for (String path : index.getDeleted()) {
            dest = new File(root, path);
            if (!dest.exists() || dest.isDirectory()) continue;
            FileUtils.forceDelete((File)dest);
        }
        for (String path : index.getAdded()) {
            dest = new File(root, path);
            input = archive.get(path);
            throwable = null;
            try {
                FileUtils.copyInputStreamToFile((InputStream)input, (File)dest);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                input.close();
            }
        }
        for (String path : index.getUpdated()) {
            dest = new File(root, path);
            input = archive.get(path);
            throwable = null;
            try {
                FileUtils.copyInputStreamToFile((InputStream)input, (File)dest);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                input.close();
            }
        }
    }

    @ConstructorProperties(value={"context"})
    public ApplyStep(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.context = context;
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplyStep)) {
            return false;
        }
        ApplyStep other = (ApplyStep)o;
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    public String toString() {
        return "ApplyStep(context=" + this.getContext() + ")";
    }
}

