/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patcher.runtime;

import com.suncode.autoupdate.patcher.Context;
import com.suncode.autoupdate.patcher.Logger;
import com.suncode.autoupdate.patcher.Patcher;
import com.suncode.autoupdate.patcher.PatcherPlan;
import com.suncode.autoupdate.patcher.Rollbacks;
import java.io.File;
import java.util.Optional;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Context context = new Context(new File(args[0]));
        Logger.configure(context.patcherDir());
        Logger.info("Upgrade started", new Object[0]);
        try {
            Optional<PatcherPlan> plan = PatcherPlan.load(context);
            if (plan.isPresent()) {
                PatcherPlan patcherPlan = plan.get();
                if (!patcherPlan.shouldApply()) {
                    Logger.info("Skipping patcher because it should not be applied before %s", patcherPlan.getApplyAfter());
                } else if (!patcherPlan.getPatches().isEmpty()) {
                    Logger.info("Found %s patches to apply", patcherPlan.getPatches().size());
                    new Patcher(context, patcherPlan).applyPatch();
                } else if (!patcherPlan.getRollbacks().isEmpty()) {
                    Logger.info("Found %s rollbacks to apply", patcherPlan.getRollbacks().size());
                    new Rollbacks(context, patcherPlan).applyRollback();
                } else {
                    Logger.info("Plan is empty", new Object[0]);
                }
            } else {
                Logger.info("Nothing to patch", new Object[0]);
            }
        }
        catch (Exception e) {
            Logger.error("Patching failed with error", e);
        }
        finally {
            Logger.close();
        }
    }
}

