/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patcher;

import com.suncode.autoupdate.patcher.Logger;
import com.suncode.autoupdate.server.client.api.EventData;
import com.suncode.autoupdate.server.client.api.Events;
import java.beans.ConstructorProperties;
import java.util.UUID;

public class SafeEventsSender {
    private final Events events;

    public void updateSuccess(UUID patch, EventData eventData) {
        this.safe(() -> this.events.updateSuccess(patch, eventData));
    }

    public void updateError(UUID patch, EventData eventData) {
        this.safe(() -> this.events.updateError(patch, eventData));
    }

    public void rollbackSuccess(UUID patch, EventData eventData) {
        this.safe(() -> this.events.rollbackSuccess(patch, eventData));
    }

    public void rollbackError(UUID patch, EventData eventData) {
        this.safe(() -> this.events.rollbackError(patch, eventData));
    }

    private void safe(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            Logger.error("Failed to send event", e);
        }
    }

    @ConstructorProperties(value={"events"})
    public SafeEventsSender(Events events) {
        this.events = events;
    }
}

