/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patcher;

import com.google.common.base.Preconditions;
import com.suncode.autoupdate.patch.plusworkflow.ValidationResult;
import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patcher.Context;
import com.suncode.autoupdate.patcher.Logger;
import com.suncode.autoupdate.patcher.PatcherPlan;
import com.suncode.autoupdate.patcher.SafeEventsSender;
import com.suncode.autoupdate.patcher.cleanup.Cleaner;
import com.suncode.autoupdate.patcher.step.ApplyStep;
import com.suncode.autoupdate.patcher.step.Validator;
import com.suncode.autoupdate.server.client.UpdateServerClient;
import com.suncode.autoupdate.server.client.api.EventData;
import com.suncode.autoupdate.server.client.api.Events;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;

public final class Rollbacks {
    @NonNull
    private final Context context;
    @NonNull
    private final PatcherPlan plan;

    public void applyRollback() {
        Validator validator = new Validator(this.context);
        ApplyStep applyStep = new ApplyStep(this.context);
        Events events = UpdateServerClient.builder().apiToken(this.plan.getClient().getToken()).environment(this.plan.getClient().getEnvironment()).updateServerAddress(this.plan.getServerURI()).build().events();
        for (String backupPath : this.plan.getRollbacks()) {
            this.doApplyBackup(backupPath, validator, applyStep, new SafeEventsSender(events));
        }
        Cleaner cleaner = new Cleaner(this.context);
        cleaner.clean();
    }

    private void doApplyBackup(String backupPath, Validator validator, ApplyStep applyStep, SafeEventsSender events) {
        Optional<Archive> archive = this.readArchive(backupPath);
        if (!archive.isPresent()) {
            throw new IllegalStateException(String.format("Backup [%s] could not be found in backups dir. Patcher will exit.", backupPath));
        }
        try (PatcherUnit unit = new PatcherUnit(archive.get());){
            unit.init();
            Archive patchArchive = unit.getArchive();
            UUID patchId = UUID.fromString(patchArchive.getMeta().getPatchId());
            ValidationResult validation = null;
            try {
                validation = validator.validate(patchArchive);
                if (!validation.valid()) {
                    throw new IllegalStateException("Validation failed");
                }
                Logger.info("Applying rollback [%s]", patchArchive.getMeta());
                applyStep.applyPatch(patchArchive);
                this.context.setCurrentVersion(patchArchive.getMeta().getToVersion());
                Logger.info("Rollback applied [%s]", patchArchive.getMeta());
                events.rollbackSuccess(patchId, EventData.builder().success(true).validation(validation).build());
            }
            catch (Throwable t) {
                Logger.error("Rollback from file [%s] failed", backupPath);
                t.printStackTrace();
                events.rollbackError(patchId, EventData.builder().success(false).errorCause(t.getMessage()).validation(validation).build());
            }
        }
    }

    private Optional<Archive> readArchive(String backup) {
        File archiveFile = new File(this.context.patcherDir(), "backups/" + backup);
        if (archiveFile.exists()) {
            return Optional.of(new Archive(archiveFile));
        }
        return Optional.empty();
    }

    @ConstructorProperties(value={"context", "plan"})
    public Rollbacks(@NonNull Context context, @NonNull PatcherPlan plan) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (plan == null) {
            throw new NullPointerException("plan is marked non-null but is null");
        }
        this.context = context;
        this.plan = plan;
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    @NonNull
    public PatcherPlan getPlan() {
        return this.plan;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rollbacks)) {
            return false;
        }
        Rollbacks other = (Rollbacks)o;
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        PatcherPlan this$plan = this.getPlan();
        PatcherPlan other$plan = other.getPlan();
        return !(this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        PatcherPlan $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
        return result;
    }

    public String toString() {
        return "Rollbacks(context=" + this.getContext() + ", plan=" + this.getPlan() + ")";
    }

    private final class PatcherUnit
    implements AutoCloseable {
        private final Archive archive;

        public void init() {
            this.archive.open();
            String startVersion = this.archive.getMeta().getFromVersion();
            Preconditions.checkState((boolean)Rollbacks.this.context.getCurrentVersion().equals(startVersion), (Object)String.format("Patch [%s] updates system from version [%s], but current version is [%s]", this.archive.getMeta().getPatchId(), startVersion, Rollbacks.this.context.getCurrentVersion()));
        }

        @Override
        public void close() throws Exception {
            this.archive.close();
        }

        @ConstructorProperties(value={"archive"})
        public PatcherUnit(Archive archive) {
            this.archive = archive;
        }

        public Archive getArchive() {
            return this.archive;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PatcherUnit)) {
                return false;
            }
            PatcherUnit other = (PatcherUnit)o;
            Archive this$archive = this.getArchive();
            Archive other$archive = other.getArchive();
            return !(this$archive == null ? other$archive != null : !this$archive.equals(other$archive));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Archive $archive = this.getArchive();
            result = result * 59 + ($archive == null ? 43 : $archive.hashCode());
            return result;
        }

        public String toString() {
            return "Rollbacks.PatcherUnit(archive=" + this.getArchive() + ")";
        }
    }
}

