package com.suncode.autoupdate.patcher.step;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.FileUtils;

import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patch.plusworkflow.archive.Index;
import com.suncode.autoupdate.patcher.Context;

import lombok.NonNull;
import lombok.Value;

@Value
public class ApplyStep
{
    @NonNull
    Context context;
    
    public void applyPatch( Archive archive )
        throws IOException
    {  
        Index index = archive.getIndex();
        File root = context.getRoot();

        // delete
        for ( String path : index.getDeleted() )
        {
            File dest = new File( root, path );
            if ( dest.exists() && !dest.isDirectory() )
            {
                FileUtils.forceDelete( dest );
            }
        }

        // new
        for ( String path : index.getAdded() )
        {
            File dest = new File( root, path );
            try(InputStream input = archive.get( path )) {
                FileUtils.copyInputStreamToFile( input, dest );
            }
        }
        
        // update --> override
        for ( String path : index.getUpdated() )
        {
            File dest = new File( root, path );
            try(InputStream input = archive.get( path )) {
                FileUtils.copyInputStreamToFile( input, dest );
            }
        }
    }
}
