package com.suncode.autoupdate.patcher.runtime;

import com.suncode.autoupdate.patcher.*;

import java.io.File;
import java.util.Optional;

public class Main {
    public static void main(String[] args) {
        Context context = new Context(new File(args[0]));
        Logger.configure(context.patcherDir());

        Logger.info("Upgrade started");
        try {
            Optional<PatcherPlan> plan = PatcherPlan.load(context);
            if (plan.isPresent()) {
                PatcherPlan patcherPlan = plan.get();
                if (!patcherPlan.shouldApply()) {
                    Logger.info("Skipping patcher because it should not be applied before %s", patcherPlan.getApplyAfter());
                } else if (!patcherPlan.getPatches().isEmpty()) {
                    Logger.info("Found %s patches to apply", patcherPlan.getPatches().size());
                    new Patcher(context, patcherPlan).applyPatch();
                } else if (!patcherPlan.getRollbacks().isEmpty()) {
                    Logger.info("Found %s rollbacks to apply", patcherPlan.getRollbacks().size());
                    new Rollbacks(context, patcherPlan).applyRollback();
                } else {
                    Logger.info("Plan is empty");
                }
            } else {
                Logger.info("Nothing to patch");
            }
        } catch (Exception e) {
            Logger.error("Patching failed with error", e);
        }
        finally {
            Logger.close();
        }
    }
}
