package com.suncode.autoupdate.patcher.cleanup;

import java.io.File;
import java.io.IOException;

import com.suncode.autoupdate.patcher.Logger;
import org.apache.commons.io.FileUtils;

import com.suncode.autoupdate.patcher.Context;

import lombok.NonNull;
import lombok.Value;

@Value
public class Cleaner
{
    @NonNull
    Context context;

    public void clean()
    {
        // wszystkie pending patche
        File pendingDir = new File( context.patcherDir(), "pending" );
        try
        {
            FileUtils.cleanDirectory( pendingDir );
        }
        catch ( IOException e )
        {
            Logger.error("Failed to clean", e);
        }

        // update plan
        File updatePlan = new File( context.patcherDir(), "patcher.plan" );
        updatePlan.delete();
    }
}
