package com.suncode.autoupdate.patcher;

import com.suncode.autoupdate.server.client.api.EventData;
import com.suncode.autoupdate.server.client.api.Events;
import lombok.AccessLevel;
import lombok.RequiredArgsConstructor;
import lombok.experimental.FieldDefaults;

import java.util.UUID;

import static lombok.AccessLevel.PRIVATE;

@RequiredArgsConstructor
@FieldDefaults(makeFinal = true, level = PRIVATE)
public class SafeEventsSender {
    Events events;

    public void updateSuccess(UUID patch, EventData eventData) {
        safe(() -> events.updateSuccess(patch, eventData));
    }

    public void updateError(UUID patch, EventData eventData) {
        safe(() -> events.updateError(patch, eventData));
    }

    public void rollbackSuccess(UUID patch, EventData eventData) {
        safe(() -> events.rollbackSuccess(patch, eventData));
    }

    public void rollbackError(UUID patch, EventData eventData) {
        safe(() -> events.rollbackError(patch, eventData));
    }

    private void safe(Runnable runnable) {
        try {
            runnable.run();
        } catch (Exception e) {
            Logger.error("Failed to send event", e);
        }
    }
}
