/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patcher.cleanup;

import com.suncode.autoupdate.patcher.Context;
import com.suncode.autoupdate.patcher.Logger;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;

public final class Cleaner {
    @NonNull
    private final Context context;

    public void clean() {
        File pendingDir = new File(this.context.patcherDir(), "pending");
        try {
            FileUtils.cleanDirectory((File)pendingDir);
        }
        catch (IOException e) {
            Logger.error("Failed to clean", e);
        }
        File updatePlan = new File(this.context.patcherDir(), "patcher.plan");
        updatePlan.delete();
    }

    @ConstructorProperties(value={"context"})
    public Cleaner(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.context = context;
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cleaner)) {
            return false;
        }
        Cleaner other = (Cleaner)o;
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    public String toString() {
        return "Cleaner(context=" + this.getContext() + ")";
    }
}

