/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patcher;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.suncode.autoupdate.patcher.Context;
import com.suncode.autoupdate.server.client.ApiToken;
import com.suncode.autoupdate.server.client.Environment;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;

public class PatcherPlan {
    @NonNull
    URI serverURI;
    @NonNull
    String version;
    @NonNull
    List<UUID> patches;
    @NonNull
    List<String> rollbacks;
    @NonNull
    ClientContext client;
    Date applyAfter;

    public boolean shouldApply() {
        return this.applyAfter == null || this.applyAfter.before(new Date());
    }

    public void save(Context context) {
        File patcherPlanFile = PatcherPlan.patcherPlan(context);
        try (FileWriter writer = new FileWriter(patcherPlanFile);){
            PatcherPlan.json().writeValue((Writer)writer, (Object)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<PatcherPlan> load(Context context) {
        File patcherPlanFile = PatcherPlan.patcherPlan(context);
        if (!patcherPlanFile.exists()) return Optional.empty();
        try (FileInputStream input = new FileInputStream(patcherPlanFile);){
            Optional<Object> optional = Optional.of(PatcherPlan.json().readValue((InputStream)input, PatcherPlan.class));
            return optional;
        }
    }

    private static File patcherPlan(Context context) {
        return new File(context.patcherDir(), "patcher.plan");
    }

    private static ObjectMapper json() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper;
    }

    public static PatcherPlanBuilder builder() {
        return new PatcherPlanBuilder();
    }

    @NonNull
    public URI getServerURI() {
        return this.serverURI;
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    @NonNull
    public List<UUID> getPatches() {
        return this.patches;
    }

    @NonNull
    public List<String> getRollbacks() {
        return this.rollbacks;
    }

    @NonNull
    public ClientContext getClient() {
        return this.client;
    }

    public Date getApplyAfter() {
        return this.applyAfter;
    }

    public void setServerURI(@NonNull URI serverURI) {
        if (serverURI == null) {
            throw new NullPointerException("serverURI is marked non-null but is null");
        }
        this.serverURI = serverURI;
    }

    public void setVersion(@NonNull String version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.version = version;
    }

    public void setPatches(@NonNull List<UUID> patches) {
        if (patches == null) {
            throw new NullPointerException("patches is marked non-null but is null");
        }
        this.patches = patches;
    }

    public void setRollbacks(@NonNull List<String> rollbacks) {
        if (rollbacks == null) {
            throw new NullPointerException("rollbacks is marked non-null but is null");
        }
        this.rollbacks = rollbacks;
    }

    public void setClient(@NonNull ClientContext client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }

    public void setApplyAfter(Date applyAfter) {
        this.applyAfter = applyAfter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatcherPlan)) {
            return false;
        }
        PatcherPlan other = (PatcherPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$serverURI = this.getServerURI();
        URI other$serverURI = other.getServerURI();
        if (this$serverURI == null ? other$serverURI != null : !((Object)this$serverURI).equals(other$serverURI)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List<UUID> this$patches = this.getPatches();
        List<UUID> other$patches = other.getPatches();
        if (this$patches == null ? other$patches != null : !((Object)this$patches).equals(other$patches)) {
            return false;
        }
        List<String> this$rollbacks = this.getRollbacks();
        List<String> other$rollbacks = other.getRollbacks();
        if (this$rollbacks == null ? other$rollbacks != null : !((Object)this$rollbacks).equals(other$rollbacks)) {
            return false;
        }
        ClientContext this$client = this.getClient();
        ClientContext other$client = other.getClient();
        if (this$client == null ? other$client != null : !((Object)this$client).equals(other$client)) {
            return false;
        }
        Date this$applyAfter = this.getApplyAfter();
        Date other$applyAfter = other.getApplyAfter();
        return !(this$applyAfter == null ? other$applyAfter != null : !((Object)this$applyAfter).equals(other$applyAfter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PatcherPlan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $serverURI = this.getServerURI();
        result = result * 59 + ($serverURI == null ? 43 : ((Object)$serverURI).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List<UUID> $patches = this.getPatches();
        result = result * 59 + ($patches == null ? 43 : ((Object)$patches).hashCode());
        List<String> $rollbacks = this.getRollbacks();
        result = result * 59 + ($rollbacks == null ? 43 : ((Object)$rollbacks).hashCode());
        ClientContext $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : ((Object)$client).hashCode());
        Date $applyAfter = this.getApplyAfter();
        result = result * 59 + ($applyAfter == null ? 43 : ((Object)$applyAfter).hashCode());
        return result;
    }

    public String toString() {
        return "PatcherPlan(serverURI=" + this.getServerURI() + ", version=" + this.getVersion() + ", patches=" + this.getPatches() + ", rollbacks=" + this.getRollbacks() + ", client=" + this.getClient() + ", applyAfter=" + this.getApplyAfter() + ")";
    }

    @ConstructorProperties(value={"serverURI", "version", "patches", "rollbacks", "client", "applyAfter"})
    public PatcherPlan(@NonNull URI serverURI, @NonNull String version, @NonNull List<UUID> patches, @NonNull List<String> rollbacks, @NonNull ClientContext client, Date applyAfter) {
        if (serverURI == null) {
            throw new NullPointerException("serverURI is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (patches == null) {
            throw new NullPointerException("patches is marked non-null but is null");
        }
        if (rollbacks == null) {
            throw new NullPointerException("rollbacks is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.serverURI = serverURI;
        this.version = version;
        this.patches = patches;
        this.rollbacks = rollbacks;
        this.client = client;
        this.applyAfter = applyAfter;
    }

    public PatcherPlan() {
    }

    public static class PatcherPlanBuilder {
        private URI serverURI;
        private String version;
        private List<UUID> patches;
        private List<String> rollbacks;
        private ClientContext client;
        private Date applyAfter;

        PatcherPlanBuilder() {
        }

        public PatcherPlanBuilder serverURI(@NonNull URI serverURI) {
            if (serverURI == null) {
                throw new NullPointerException("serverURI is marked non-null but is null");
            }
            this.serverURI = serverURI;
            return this;
        }

        public PatcherPlanBuilder version(@NonNull String version) {
            if (version == null) {
                throw new NullPointerException("version is marked non-null but is null");
            }
            this.version = version;
            return this;
        }

        public PatcherPlanBuilder patches(@NonNull List<UUID> patches) {
            if (patches == null) {
                throw new NullPointerException("patches is marked non-null but is null");
            }
            this.patches = patches;
            return this;
        }

        public PatcherPlanBuilder rollbacks(@NonNull List<String> rollbacks) {
            if (rollbacks == null) {
                throw new NullPointerException("rollbacks is marked non-null but is null");
            }
            this.rollbacks = rollbacks;
            return this;
        }

        public PatcherPlanBuilder client(@NonNull ClientContext client) {
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            this.client = client;
            return this;
        }

        public PatcherPlanBuilder applyAfter(Date applyAfter) {
            this.applyAfter = applyAfter;
            return this;
        }

        public PatcherPlan build() {
            return new PatcherPlan(this.serverURI, this.version, this.patches, this.rollbacks, this.client, this.applyAfter);
        }

        public String toString() {
            return "PatcherPlan.PatcherPlanBuilder(serverURI=" + this.serverURI + ", version=" + this.version + ", patches=" + this.patches + ", rollbacks=" + this.rollbacks + ", client=" + this.client + ", applyAfter=" + this.applyAfter + ")";
        }
    }

    public static class ClientContext {
        ApiToken token;
        Environment environment;

        public static ClientContextBuilder builder() {
            return new ClientContextBuilder();
        }

        public ApiToken getToken() {
            return this.token;
        }

        public Environment getEnvironment() {
            return this.environment;
        }

        public void setToken(ApiToken token) {
            this.token = token;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientContext)) {
                return false;
            }
            ClientContext other = (ClientContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ApiToken this$token = this.getToken();
            ApiToken other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            Environment this$environment = this.getEnvironment();
            Environment other$environment = other.getEnvironment();
            return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClientContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ApiToken $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            Environment $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            return result;
        }

        public String toString() {
            return "PatcherPlan.ClientContext(token=" + this.getToken() + ", environment=" + this.getEnvironment() + ")";
        }

        @ConstructorProperties(value={"token", "environment"})
        public ClientContext(ApiToken token, Environment environment) {
            this.token = token;
            this.environment = environment;
        }

        public ClientContext() {
        }

        public static class ClientContextBuilder {
            private ApiToken token;
            private Environment environment;

            ClientContextBuilder() {
            }

            public ClientContextBuilder token(ApiToken token) {
                this.token = token;
                return this;
            }

            public ClientContextBuilder environment(Environment environment) {
                this.environment = environment;
                return this;
            }

            public ClientContext build() {
                return new ClientContext(this.token, this.environment);
            }

            public String toString() {
                return "PatcherPlan.ClientContext.ClientContextBuilder(token=" + this.token + ", environment=" + this.environment + ")";
            }
        }
    }
}

