/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patcher;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.suncode.autoupdate.patch.plusworkflow.ValidationResult;
import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patcher.Context;
import com.suncode.autoupdate.patcher.Logger;
import com.suncode.autoupdate.patcher.PatcherPlan;
import com.suncode.autoupdate.patcher.SafeEventsSender;
import com.suncode.autoupdate.patcher.cleanup.Cleaner;
import com.suncode.autoupdate.patcher.step.ApplyStep;
import com.suncode.autoupdate.patcher.step.BackupStep;
import com.suncode.autoupdate.patcher.step.Validator;
import com.suncode.autoupdate.server.client.UpdateServerClient;
import com.suncode.autoupdate.server.client.api.EventData;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;

public final class Patcher {
    @NonNull
    private final Context context;
    @NonNull
    private final PatcherPlan plan;

    public void applyPatch() {
        Validator validator = new Validator(this.context);
        BackupStep backup = new BackupStep(this.context);
        ApplyStep applyStep = new ApplyStep(this.context);
        SafeEventsSender events = new SafeEventsSender(UpdateServerClient.builder().apiToken(this.plan.getClient().getToken()).environment(this.plan.getClient().getEnvironment()).updateServerAddress(this.plan.getServerURI()).build().events());
        for (UUID patchId : this.plan.getPatches()) {
            ArrayList validationResultRef = Lists.newArrayList();
            try {
                this.doApplyPatch(patchId, validator, backup, applyStep, events, validationResultRef);
                events.updateSuccess(patchId, EventData.builder().success(true).validation((ValidationResult)validationResultRef.get(0)).build());
            }
            catch (Throwable t) {
                Logger.error("Error applying patch %s", patchId, t);
                events.updateError(patchId, EventData.builder().success(false).errorCause(t.getMessage()).build());
            }
        }
        Cleaner cleaner = new Cleaner(this.context);
        cleaner.clean();
    }

    private void doApplyPatch(UUID patchId, Validator validator, BackupStep backup, ApplyStep applyStep, SafeEventsSender events, List<ValidationResult> validationResultRef) {
        Optional<Archive> archive = this.readArchive(patchId);
        if (!archive.isPresent()) {
            throw new IllegalStateException(String.format("Patch [%s] could not be found in pending dir. Patcher will exit.", patchId));
        }
        try (PatcherUnit unit = new PatcherUnit((Archive)archive.get());){
            unit.init();
            Archive patchArchive = unit.getArchive();
            ValidationResult validation = validator.validate(patchArchive);
            validationResultRef.add(validation);
            File backupFile = backup.createBackup(patchArchive);
            try {
                Logger.info("Applying patch [%s]", patchArchive.getMeta());
                applyStep.applyPatch(patchArchive);
                this.context.setCurrentVersion(patchArchive.getMeta().getToVersion());
                Logger.info("Patch [%s] applied", patchArchive.getMeta());
            }
            catch (Exception e) {
                Logger.error("Applying patch [%s] failed", patchId);
                Logger.info("Trying to rollback patch from backup [%s]", backupFile.getAbsolutePath());
                try (Archive backupArchive = new Archive(backupFile);){
                    backupArchive.open();
                    applyStep.applyPatch(backupArchive);
                    this.context.setCurrentVersion(backupArchive.getMeta().getToVersion());
                    events.rollbackSuccess(patchId, EventData.builder().success(true).build());
                }
                catch (Exception e1) {
                    Logger.error("Rollback from file [%s] failed", backupFile.getAbsolutePath());
                    events.rollbackError(patchId, EventData.builder().success(false).errorCause(e1.getMessage()).build());
                }
                throw e;
            }
        }
    }

    private Optional<Archive> readArchive(UUID id) {
        File archiveFile = new File(this.context.patcherDir(), "pending/" + id.toString());
        if (archiveFile.exists()) {
            return Optional.of((Object)new Archive(archiveFile));
        }
        return Optional.absent();
    }

    @ConstructorProperties(value={"context", "plan"})
    public Patcher(@NonNull Context context, @NonNull PatcherPlan plan) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (plan == null) {
            throw new NullPointerException("plan is marked non-null but is null");
        }
        this.context = context;
        this.plan = plan;
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    @NonNull
    public PatcherPlan getPlan() {
        return this.plan;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Patcher)) {
            return false;
        }
        Patcher other = (Patcher)o;
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        PatcherPlan this$plan = this.getPlan();
        PatcherPlan other$plan = other.getPlan();
        return !(this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        PatcherPlan $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
        return result;
    }

    public String toString() {
        return "Patcher(context=" + this.getContext() + ", plan=" + this.getPlan() + ")";
    }

    private final class PatcherUnit
    implements AutoCloseable {
        private final Archive archive;

        public void init() {
            this.archive.open();
            String startVersion = this.archive.getMeta().getFromVersion();
            Preconditions.checkState((boolean)Patcher.this.context.getCurrentVersion().equals(startVersion), (Object)String.format("Patch [%s] updates system from version [%s], but current version is [%s]", this.archive.getMeta().getPatchId(), startVersion, Patcher.this.context.getCurrentVersion()));
        }

        @Override
        public void close() throws Exception {
            this.archive.close();
        }

        @ConstructorProperties(value={"archive"})
        public PatcherUnit(Archive archive) {
            this.archive = archive;
        }

        public Archive getArchive() {
            return this.archive;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PatcherUnit)) {
                return false;
            }
            PatcherUnit other = (PatcherUnit)o;
            Archive this$archive = this.getArchive();
            Archive other$archive = other.getArchive();
            return !(this$archive == null ? other$archive != null : !this$archive.equals(other$archive));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Archive $archive = this.getArchive();
            result = result * 59 + ($archive == null ? 43 : $archive.hashCode());
            return result;
        }

        public String toString() {
            return "Patcher.PatcherUnit(archive=" + this.getArchive() + ")";
        }
    }
}

