/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patcher;

import java.io.File;
import java.util.Optional;
import java.util.logging.ErrorManager;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public class Logger {
    private static volatile Handler handler;

    public static void configure(File directory) {
        try {
            File logs = new File(directory, "logs");
            FileUtils.forceMkdir((File)logs);
            handler = new FileHandler(logs.getAbsolutePath() + "/update-%u_%g.log", 0xA00000, 10, true);
        }
        catch (Exception e) {
            System.out.println("Error: failed to configure file logging, falling back to stdout");
            e.printStackTrace(System.out);
            handler = new StreamHandler(System.out, new SimpleFormatter());
        }
        handler.setLevel(Level.ALL);
        handler.setFormatter(new SimpleFormatter());
        handler.setErrorManager(new ErrorManager());
    }

    public static void close() {
        if (handler != null) {
            handler.close();
        }
    }

    public static void info(String message, Object ... args) {
        Logger.log(Level.INFO, message, args);
    }

    public static void warn(String message, Object ... args) {
        Logger.log(Level.WARNING, message, args);
    }

    public static void error(String message, Object ... args) {
        Logger.log(Level.SEVERE, message, args);
    }

    private static void log(Level level, String message, Object ... args) {
        Optional<Throwable> error = Stream.of(args).filter(arg -> arg instanceof Throwable).map(arg -> (Throwable)arg).findFirst();
        LogRecord record = new LogRecord(level, String.format(message, args));
        record.setSourceClassName("");
        record.setSourceMethodName("");
        error.ifPresent(record::setThrown);
        handler.publish(record);
        handler.flush();
    }
}

