/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patcher;

import java.beans.ConstructorProperties;
import java.io.File;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;

public final class Context {
    @NonNull
    private final File root;

    public File patcherDir() {
        return new File(this.root, ".patcher");
    }

    public boolean hasVersion() {
        return this.versionFile().exists();
    }

    public String getCurrentVersion() {
        return FileUtils.readFileToString((File)this.versionFile()).trim();
    }

    public void setCurrentVersion(String version) {
        FileUtils.writeStringToFile((File)this.versionFile(), (String)version);
    }

    private File versionFile() {
        return new File(this.root, ".autoupdate");
    }

    public static ContextBuilder builder() {
        return new ContextBuilder();
    }

    @NonNull
    public File getRoot() {
        return this.root;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Context)) {
            return false;
        }
        Context other = (Context)o;
        File this$root = this.getRoot();
        File other$root = other.getRoot();
        return !(this$root == null ? other$root != null : !((Object)this$root).equals(other$root));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : ((Object)$root).hashCode());
        return result;
    }

    public String toString() {
        return "Context(root=" + this.getRoot() + ")";
    }

    @ConstructorProperties(value={"root"})
    public Context(@NonNull File root) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        this.root = root;
    }

    public static class ContextBuilder {
        private File root;

        ContextBuilder() {
        }

        public ContextBuilder root(@NonNull File root) {
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            this.root = root;
            return this;
        }

        public Context build() {
            return new Context(this.root);
        }

        public String toString() {
            return "Context.ContextBuilder(root=" + this.root + ")";
        }
    }
}

