/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patcher.step;

import com.google.common.hash.Hashing;
import com.suncode.autoupdate.patch.PatchMeta;
import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patch.plusworkflow.archive.Index;
import com.suncode.autoupdate.patch.plusworkflow.archive.Meta;
import com.suncode.autoupdate.patch.plusworkflow.archive.PatchAssembler;
import com.suncode.autoupdate.patcher.Context;
import com.suncode.autoupdate.patcher.Logger;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public final class BackupStep {
    @NonNull
    private final Context context;

    public File createBackup(Archive archive) throws IOException {
        String prefix = this.uniqueName(archive);
        File backupDir = new File(this.context.patcherDir(), "backups");
        backupDir.mkdirs();
        File backup = new File(backupDir, prefix + ".backup");
        Logger.info("Creating backup of %s in %s", archive.getMeta(), backup.getAbsolutePath());
        this.generateBackup(this.context, backup, archive);
        return backup;
    }

    private void generateBackup(Context context, File backup, Archive archive) throws IOException {
        FileUtils.forceMkdir((File)backup.getParentFile());
        Meta meta = archive.getMeta();
        PatchMeta revered = new PatchMeta(meta.getPatchId(), meta.getToVersion(), meta.getFromVersion());
        Archive.assemble((PatchMeta)revered, (File)backup, patch -> this.doGenerate(context, archive, patch));
    }

    private void doGenerate(final Context context, Archive archive, final PatchAssembler patch) throws IOException {
        final File root = context.getRoot();
        final Index index = archive.getIndex();
        Files.walkFileTree(root.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.endsWith(".autoupdate")) {
                    return FileVisitResult.CONTINUE;
                }
                String relative = FilenameUtils.normalize((String)root.toPath().relativize(file).toString(), (boolean)true);
                if (!(index.isAdded(relative) || index.isUpdated(relative) || index.isDeleted(relative))) {
                    try {
                        patch.checksum(relative, com.google.common.io.Files.asByteSource((File)file.toFile()).hash(Hashing.md5()));
                    }
                    catch (Exception e) {
                        Logger.warn("Could not generate checksum for file %s", file.toAbsolutePath(), e);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return dir.toFile().equals(context.patcherDir()) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }
        });
        for (String path : index.getChanged()) {
            File resolved = new File(root, path);
            index.changeFor(path).ifPresent(change -> {
                switch (change) {
                    case ADDED: {
                        patch.delete(path);
                        patch.checksum(path, index.getChecksum(path));
                        break;
                    }
                    case UPDATED: {
                        this.openOr(resolved, stream -> {
                            patch.update(path, stream);
                            patch.checksum(path, index.getChecksum(path));
                        }, () -> {
                            Logger.warn("Expected file %s to exists - will delete instead", path);
                            patch.delete(path);
                            patch.checksum(path, index.getChecksum(path));
                        });
                        break;
                    }
                    case DELETED: {
                        this.openOr(resolved, stream -> patch.add(path, stream), () -> Logger.warn("Expected file %s to exists - ignoring.", path));
                    }
                }
            });
        }
    }

    private void openOr(File file, Consumer<InputStream> consumer, Runnable fileNotFound) {
        try (FileInputStream in = new FileInputStream(file);){
            consumer.accept(in);
        }
        catch (FileNotFoundException e) {
            fileNotFound.run();
        }
    }

    private String uniqueName(Archive archive) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss");
        return archive.getMeta().getPatchId() + "_" + sdf.format(new Date());
    }

    @ConstructorProperties(value={"context"})
    public BackupStep(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.context = context;
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BackupStep)) {
            return false;
        }
        BackupStep other = (BackupStep)o;
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    public String toString() {
        return "BackupStep(context=" + this.getContext() + ")";
    }
}

