package com.suncode.autoupdate.patcher;

import org.apache.commons.io.FileUtils;

import java.io.File;
import java.util.Optional;
import java.util.logging.*;
import java.util.stream.Stream;

import static java.util.logging.Level.*;

public class Logger {
    private static volatile Handler handler;

    public static void configure(File directory) {
        try {
            File logs = new File(directory, "logs");
            FileUtils.forceMkdir(logs);
            handler = new FileHandler(logs.getAbsolutePath() + "/update-%u_%g.log", 10 * 1024 * 1024, 10, true);
        } catch (Exception e) {
            System.out.println("Error: failed to configure file logging, falling back to stdout");
            e.printStackTrace(System.out);

            handler = new StreamHandler(System.out, new SimpleFormatter());
        }

        handler.setLevel(ALL);
        handler.setFormatter(new SimpleFormatter());
        handler.setErrorManager(new ErrorManager());
    }

    public static void close() {
        if (handler != null) {
            handler.close();
        }
    }

    public static void info(String message, Object... args) {
        log(INFO, message, args);
    }

    public static void warn(String message, Object... args) {
        log(WARNING, message, args);
    }

    public static void error(String message, Object... args) {
        log(SEVERE, message, args);
    }

    private static void log(Level level, String message, Object... args) {
        Optional<Throwable> error = Stream.of(args)
                .filter(arg -> arg instanceof Throwable)
                .map(arg -> (Throwable) arg)
                .findFirst();

        LogRecord record = new LogRecord(level, String.format(message, args));
        record.setSourceClassName("");
        record.setSourceMethodName("");
        error.ifPresent(record::setThrown);

        handler.publish(record);
        handler.flush();
    }

}
