package com.suncode.autoupdate.patcher;

import lombok.*;
import org.apache.commons.io.FileUtils;

import java.io.File;

@Value
@Builder
@RequiredArgsConstructor
public class Context {
    @NonNull
    File root;

    public File patcherDir() {
       return new File( root, ".patcher" );
    }

    public boolean hasVersion() {
        return versionFile().exists();
    }

    @SneakyThrows
    public String getCurrentVersion() {
        return FileUtils.readFileToString(versionFile()).trim();
    }

    @SneakyThrows
    public void setCurrentVersion(String version) {
        FileUtils.writeStringToFile(versionFile(), version);
    }

    private File versionFile() {
        return new File(root, ".autoupdate");
    }
}
