auApp.pcmp.push(function(Ext) {

    var loaded = false;
    var state = {};
    Ext.define('au.State', {
        mixins: {
            observable: 'Ext.util.Observable'
        },
        singleton: true,
        constructor: function() {
            this.mixins.observable.constructor.call(this, {});
            this.reload();
            this.refreshTask = setInterval(function() {
                if (au.Viewport && au.Viewport.getEl() &&
                    jQuery(au.Viewport.getEl().dom).is(':visible')) {
                    au.State.reload();
                }
            }, 2000);
        },
        reload: function(forceChange) {
            var me = this;
            if (this.reloading) {
                return;
            }
            this.reloading = true;
            jQuery.getJSON(auApp.basePath + '/status?timestamp=' + Date.now())
                .done(function(newState) {
                    var previous = JSON.stringify(state);
                    var current = JSON.stringify(newState);
                    // if (forceChange || current !== previous) {
                    state = newState;
                    loaded = true;
                    me.fireEvent('change', state);
                    // }
                })
                .always(function() {
                    me.reloading = false;
                });
        },
        get: function() {
            return state;
        },
        changed: function() {
            this.fireEvent('change', state);
        },
        bind: function(callback, scope) {
            this.on("change", callback, scope);
            this.onReady(callback);
        },
        onReady: function(fn) {
            if (loaded) {
                fn.call(window, state);
            }
            this.on('change', fn, null, {
                single: true
            });
        },
        destroy: function() {
            clearTimeout(this.refreshTask);
        }
    });

    var currentValueAccessor = [
        [Ext.Component.prototype.setVisible, "isVisible"],
        [Ext.Component.prototype.setDisabled, "isDisabled"],
        [Ext.button.Button.prototype.setText, "getText"],
        [Ext.panel.Panel.prototype.setTitle, "title"],
        [Ext.toolbar.TextItem.prototype.setText, "text"],
        [Ext.form.field.Base.prototype.setValue, "getValue"],
    ];

    Ext.define('au.StateAware', {
        statics: {
            prop: (name, setValue) => {
                return (state, cmp) => {
                    return {value: cmp.props[name](state), setValue}
                };
            }
        },
        init: function() {
            var setters = [];
            var me = this;
            var components = [];
            var layouts = [];
            if (Ext.isDefined(this.stateAware)) {
                components.push(this);
            }
            if (Ext.isFunction(this.query)) {
                components = components.concat(this.query('component[stateAware]'));
                layouts = this.query('component[stateAwareFixLayout]');
            }

            Ext.each(components, function(cmp) {
                var parentContext = this._findParentContext(cmp);
                if (parentContext != this) {
                    return true;
                }
                var stateAware = cmp.stateAware;
                if(Ext.isArray(stateAware)) {
                    setters = setters.concat(Ext.Array.map(stateAware, (setter) => {
                        let init = true;
                        let current = undefined;
                        return (state) => {
                            const {value, setValue} = setter(state, cmp);

                            if(init || JSON.stringify(value) !== JSON.stringify(current)) {
                                init = false;
                                setValue(value, cmp);
                                cmp.__dirty = true;
                                current = value;
                            }
                        };
                    }));
                }
                else if (Ext.isObject(stateAware)) {
                    Ext.Object.each(stateAware, function(key, value) {
                        setters.push(function(state, setter) {
                            var currentValue;
                            var newValue = value.call(cmp, state, me, function(current) {
                                currentValue = current;
                            });
                            
                            var setAttribute = function(value) {
                                cmp[key].call(cmp, value);
                                cmp.__dirty = true;
                            }

                            // NEW WAY
                            if(Ext.isObject(newValue) && newValue.hasOwnProperty("value") && newValue.hasOwnProperty("map")) {
                                
                                var current = Ext.isFunction(newValue.value) ? newValue.value(state, me) : newValue.value;
                                if (!cmp.rendered || JSON.stringify(current) !== JSON.stringify(setter.previous) ) {
                                    setAttribute(newValue.map(current));
                                }
                                setter.previous = current
                                return;
                            }

                            // OLD WAY
                            var fn = cmp[key];
                            if (!Ext.isDefined(currentValue)) {
                                var known = Ext.Array.findBy(currentValueAccessor, function(item) {
                                    return item[0] === fn;
                                });
                                if (known) {
                                    var accessor = cmp[known[1]];
                                    currentValue = Ext.isFunction(accessor) ? accessor.call(cmp) : accessor;
                                }
                            }
                            if (!cmp.rendered || currentValue != newValue) {
                                setAttribute(newValue)
                            }
                        });
                    });
                } else {
                    Ext.each(stateAware, function(setter) {
                        setters.push(Ext.bind(setter, cmp, [cmp], 0));
                    });
                }
            }, this);
            au.State.on('change', function(state) {
                Ext.suspendLayouts();
                try {
                    Ext.each(setters, function(setter) {
                        setter(state, setter);
                    })
                    Ext.each(layouts, function(layout) {
                        if (layout.__dirty) {
                            delete layout.__dirty;
                            layout.updateLayout();
                        }
                    });
                } finally {
                    Ext.resumeLayouts(true);
                }
            });
            Ext.each(setters, function(setter) {
                setter(state, setter);
            });
        },

        _findParentContext: function(cmp) {
            var context;
            var currentCmp = cmp;
            while (currentCmp && !context) {
                if (currentCmp.mixins && currentCmp.mixins.stateAware) {
                    context = currentCmp;
                }
                currentCmp = currentCmp.ownerCt;
            }
            return context;
        },

        whenRendered: function(fn) {
            if (this.rendered) {
                fn.call(this);
            } else {
                this.on('afterrender', fn, this, {
                    single: true
                });
            }
        }
    });
});