auApp.cmp.push(function(Ext) {

    Ext.define('au.PluginValidation', {
        extend : 'Ext.window.Window',
        title: au.t("update.plugin.validation.title"),

        closeAction: 'destroy',
        width: 800,
        modal: true,
        resizable: true,
        layout: {
            type: 'vbox',
            align : 'stretch',
            pack  : 'start'
        },

        constructor: function(props) {
            this.props = props;
            this.callParent();
        },

        initComponent : function() {
            var me = this,
                validation = me.props.validation;

            Ext.apply(me, {
                items: [{
                    xtype: "auPluginValidationList",
                    title: au.t("update.plugin.validation.required.mandatory"),
                    missing: validation.missing.mandatory,
                    flex: 1
                }, {
                    xtype: "auPluginValidationList",
                    title: au.t("update.plugin.validation.required.optional"),
                    missing: validation.missing.optional,
                    flex: 1
                }, {
                    xtype: "auPluginValidationList",
                    title: au.t("update.plugin.validation.provided.mandatory"),
                    missing: validation.provided.mandatory,
                    flex: 1
                }, {
                    xtype: "auPluginValidationList",
                    title: au.t("update.plugin.validation.provided.optional"),
                    missing: validation.provided.optional,
                    flex: 1
                }],

                buttons: [{
                    text: au.t("update.plugin.validation.continue"),
                    handler: function() {
                        me.props.retry();
                        me.close();
                    }
                },{
                    text: au.t("update.plugin.validation.cancel"),
                    handler: function() {
                        me.close();
                    }
                }]
            });

            me.callParent(arguments);
        }
    });

    Ext.define('au.PluginValidationList', {
        extend: 'Ext.grid.Panel',
        xtype: 'auPluginValidationList',
        hideHeaders: true,
        border: false,
        disableSelection: true,
        viewConfig: {
            enableTextSelection:true
        },
        
        initComponent : function() {
            var me = this;
            
            var store = new Ext.data.JsonStore({
                proxy: {
                    type: 'memory'
                },
                data: me.missing,
                autoDestroy: true,
                fields: ['key', 'version', 'requiredVersion', 'resolution']
            });

            Ext.apply(me, {
                hidden: Ext.isEmpty(me.missing),
                store: store,
                columns: [
                    { dataIndex: 'key', flex: 1 },
                    { dataIndex: 'version', width: 100},
                    { dataIndex: 'resolution', flex: 1, renderer: me.required ? me.renderResolutionRequired : me.renderResolutionProvided}
                ]
            });

            me.callParent(arguments);
        },

        renderResolutionRequired: function(resolution) {
            var text = {
                "MISSING": function(){
                    return au.t("update.plugin.validation.required.missing");
                },
                "VERSION_MISMATCH": function(){
                    return au.t("update.plugin.validation.required.mismatch", resolution.available);
                },
                "NOT_ACTIVE": function(){
                    return au.t("update.plugin.validation.required.notActive");
                }
            };
            return text[resolution.type]();
        },

        renderResolutionProvided: function(resolution, meta, record) {
            var text = {
                "VERSION_MISMATCH": function(){
                    return au.t("update.plugin.validation.provided.mismatch", record.get("requiredVersion"));
                }
            };
            return text[resolution.type]();
        }
    });
    

    au.PluginValidation.show = function(validation, retry) {
        new au.PluginValidation({
            validation: validation,
            retry: retry
        }).show();
    };
});
