/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.util;

import com.suncode.autoupdate.plusworkflow.util.Consumer;
import com.suncode.plugin.framework.PluginStoreResource;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Safe {
    private static final Logger log = LoggerFactory.getLogger(Safe.class);

    public static <T> T safe(Callable<T> callable, T defaultValue) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            log.warn("Exception when invoking safe action", (Throwable)e);
            return defaultValue;
        }
    }

    public static <T> T safeNoLog(Callable<T> callable, T defaultValue) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static void safe(Runnable routine, Consumer<Exception> handleError) {
        try {
            routine.run();
        }
        catch (Exception e) {
            if (handleError != null) {
                handleError.accept(e);
            }
            log.warn("Exception when invoking safe action", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T withInputStream(PluginStoreResource resource, Function<InputStream, T> fn) {
        try (InputStream in = resource.getInputStream();){
            InputStream inputStream = fn.apply(in);
            return (T)inputStream;
        }
    }

    private Safe() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

