/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.util;

import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Exceptions {
    private static final Logger log = LoggerFactory.getLogger(Exceptions.class);

    public static void safe(Runnable runnable) {
        Exceptions.safe(runnable, (Throwable e) -> true);
    }

    public static void safe(ThrowingRunnable runnable, Predicate<Throwable> ignoreCause) {
        Exceptions.safe((Runnable)runnable, ignoreCause);
    }

    public static void safe(Runnable runnable, Predicate<Throwable> ignoreCause) {
        block5: {
            try {
                runnable.run();
            }
            catch (Exception e) {
                if (ignoreCause.test(e)) {
                    log.error("Ignored failure", (Throwable)e);
                    break block5;
                }
                throw e;
            }
        }
    }

    private Exceptions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface ThrowingRunnable
    extends Runnable {
        @Override
        default public void run() {
            this.runSafe();
        }

        public void runSafe() throws Exception;

        public static Runnable throwing(ThrowingRunnable runnable) {
            return runnable;
        }
    }
}

