/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.system;

import com.suncode.autoupdate.tomcat.Hook;
import com.suncode.plugin.framework.Plugin;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class TomcatHook {
    private static final Logger log = LoggerFactory.getLogger(TomcatHook.class);
    private static String HOOK_JAR = "autoupdate-tomcat-hook.jar";
    private final Plugin plugin;
    private final ServletContext servletContext;

    public boolean install() {
        if (this.installed()) {
            return true;
        }
        try {
            Resource resource = this.plugin.getResource(HOOK_JAR);
            try (InputStream inputStream = resource.getInputStream();){
                Hook.get().registerHook(this.servletContext, inputStream);
            }
        }
        catch (Throwable e) {
            log.error("Error installing tomcat hook", e);
        }
        return this.installed();
    }

    public boolean installed() {
        return Hook.get().isHookRegisterd(this.servletContext);
    }

    @ConstructorProperties(value={"plugin", "servletContext"})
    @Autowired
    public TomcatHook(Plugin plugin, ServletContext servletContext) {
        this.plugin = plugin;
        this.servletContext = servletContext;
    }
}

