/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.system;

import com.github.oxo42.stateless4j.StateMachineConfig;
import com.suncode.autoupdate.patch.PatchMeta;
import com.suncode.autoupdate.patch.plusworkflow.Props;
import com.suncode.autoupdate.patch.plusworkflow.ValidationResult;
import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patcher.Context;
import com.suncode.autoupdate.patcher.PatcherPlan;
import com.suncode.autoupdate.patcher.step.Validator;
import com.suncode.autoupdate.plusworkflow.audit.Audit;
import com.suncode.autoupdate.plusworkflow.update.Changelog;
import com.suncode.autoupdate.plusworkflow.update.Patches;
import com.suncode.autoupdate.plusworkflow.update.PendingPatch;
import com.suncode.autoupdate.plusworkflow.update.UpdateEvent;
import com.suncode.autoupdate.plusworkflow.update.UpdateState;
import com.suncode.autoupdate.plusworkflow.update.download.DownloadQueue;
import com.suncode.autoupdate.plusworkflow.update.download.Downloader;
import com.suncode.autoupdate.plusworkflow.update.download.Downloads;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdate;
import com.suncode.autoupdate.plusworkflow.update.engine.UpdateEngine;
import com.suncode.autoupdate.plusworkflow.update.support.AbstractComponentUpdate;
import com.suncode.autoupdate.plusworkflow.update.support.StateSummaryMapper;
import com.suncode.autoupdate.plusworkflow.update.system.InOrderPatches;
import com.suncode.autoupdate.plusworkflow.update.system.Rollback;
import com.suncode.autoupdate.plusworkflow.update.system.Rollbacks;
import com.suncode.autoupdate.server.client.UpdateServerClient;
import com.suncode.autoupdate.server.client.api.AvailableUpdates;
import com.suncode.plugin.framework.Plugin;
import com.suncode.pwfl.SystemVersion;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.util.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class SystemUpdate
extends AbstractComponentUpdate {
    private static final Logger log = LoggerFactory.getLogger(SystemUpdate.class);
    private final Context context;
    private final Plugin plugin;
    private final Rollbacks rollbacks;
    private final Downloader downloader;

    @Autowired
    public SystemUpdate(Plugin plugin, Context context, UpdateEngine engine, DownloadQueue downloadQueue, StateSummaryMapper summaryMapper, Rollbacks rollbacks, Downloader downloader) {
        super(plugin.getPluginStore(), engine, downloadQueue, summaryMapper);
        this.context = context;
        this.plugin = plugin;
        this.rollbacks = rollbacks;
        this.downloader = downloader;
        this.getContext().getProperties().put("systemVersion", SystemVersion.getVersion());
        this.getContext().getProperties().put("rollbacks", rollbacks.discover());
        UpdateState state = (UpdateState)((Object)this.getStateMachine().getState());
        if (!(state != UpdateState.POSTPONED_BACKUP && state != UpdateState.POSTPONED_UPDATE || PatcherPlan.load((Context)context).isPresent())) {
            this.getStateMachine().fire((Object)UpdateEvent.CANCEL);
        }
    }

    @Override
    protected boolean autoConfirm() {
        return false;
    }

    @Override
    protected boolean needsValidation() {
        return true;
    }

    @Override
    protected boolean persistentState() {
        return true;
    }

    @Override
    public String key() {
        return "plusworkflow";
    }

    @Override
    protected String getProjectName() {
        if (this.getEngine().isConfigured()) {
            return this.getEngine().getConfig().getSystemProject();
        }
        return null;
    }

    @Override
    protected String getProjectDisplayName() {
        return "PlusWorkflow";
    }

    @Override
    protected String getChannelName() {
        if (this.getEngine().isConfigured()) {
            return this.getEngine().getConfig().getSystemChannel();
        }
        return null;
    }

    @Override
    protected String getVersion() {
        if (this.context.hasVersion()) {
            return this.context.getCurrentVersion();
        }
        this.error(new IllegalStateException("Cannot resolve system version"));
        return null;
    }

    @Override
    public Changelog getPendingChangelog() {
        return this.getContext().getPatchesToApply().stream().map(this::readIndex).map(index -> Changelog.builder().added(index.getAdded()).deleted(index.getDeleted()).updated(index.getUpdated()).build()).reduce(Changelog.none(), Changelog::merge);
    }

    @Override
    protected Patches getAvailablePatches(UpdateServerClient client) {
        AvailableUpdates updates = client.updates().checkNewest(this.getProjectName(), this.getChannelName(), this.getVersion());
        return new InOrderPatches(updates.getNewestVersion(), updates.getPatches());
    }

    @Override
    protected boolean applyUpdates(List<PendingPatch> patches, Downloads download) {
        Date started = new Date();
        File patcherHome = new File(this.context.getRoot(), ".patcher");
        patcherHome.mkdirs();
        File pendingDir = new File(patcherHome, "pending");
        pendingDir.mkdirs();
        for (PendingPatch pendingPatch : patches) {
            File target = new File(pendingDir, pendingPatch.getId().toString());
            InputStream in = download.patchArchive(pendingPatch).getInputStream();
            Throwable throwable = null;
            try {
                FileOutputStream outputStream = new FileOutputStream(target);
                Throwable throwable2 = null;
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)outputStream);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable2 != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    outputStream.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                in.close();
            }
        }
        ArrayList<UUID> patchesIds = new ArrayList<UUID>();
        for (PendingPatch patch : patches) {
            patchesIds.add(patch.getId());
        }
        PatcherPlan patcherPlan = PatcherPlan.builder().client(PatcherPlan.ClientContext.builder().environment(this.getEngine().getConfig().getEnvironment()).token(this.getEngine().getConfig().getApiToken()).build()).serverURI(this.getEngine().getConfig().getServerUrl()).version(this.context.getCurrentVersion()).patches(patchesIds).rollbacks(Collections.emptyList()).applyAfter(this.getContext().getApplyAfter()).build();
        patcherPlan.save(this.context);
        Resource resource = this.plugin.getResource("patcher.jar");
        File patcherBin = new File(this.context.getRoot(), ".patcher/patcher.jar");
        try (InputStream inputStream = resource.getInputStream();){
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)patcherBin);
        }
        this.getContext().getProperties().put("applyAfter", patcherPlan.getApplyAfter());
        this.audit(Audit.SYSTEM_UPDATE_SCHEDULED, started, this.param("autoupdate.audit.version-to", SystemUpdate.systemVersionWithRevision(this.getContext().getTargetPatch())), this.param("autoupdate.audit.version-from", SystemVersion.getVersionIdentifier()), this.param("autoupdate.audit.schedule-date", SystemUpdate.nullableParam(this.getContext().getApplyAfter())));
        this.getStateMachine().fire((Object)UpdateEvent.APPLIED_POSTPONE);
        return true;
    }

    @SafeVarargs
    private final void audit(Audit type, Date started, Map.Entry<String, Object> ... params) {
        ManualAuditBuilder.getInstance().type(type.key()).success(true).params((Map)Arrays.stream(params).collect(Maps.toNullableMap())).username(UserContext.current().getUser().getUserName()).started(started).build().log();
    }

    private static Object nullableParam(@Nullable Date value) {
        return value != null ? value : "";
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean validate(List<PendingPatch> patches, Downloads download) {
        Validator validator = new Validator(this.context);
        File temp = File.createTempFile("temp", ".patch");
        try {
            PendingPatch patch = patches.get(0);
            try (InputStream in = download.patchArchive(patch).getInputStream();){
                IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(temp));
            }
            var7_8 = null;
            try (Archive archive = new Archive(temp);){
                archive.open();
                ValidationResult validationResult = validator.validate(archive);
                log.info(validationResult.toFormattedString());
                this.getContext().getProperties().put("validationResult", validationResult);
                boolean bl = validationResult.valid();
                return bl;
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            temp.delete();
        }
    }

    @Override
    protected void cancelPostPoned() {
        File patcherHome = new File(this.context.getRoot(), ".patcher");
        patcherHome.mkdirs();
        File pendingDir = new File(patcherHome, "pending");
        FileUtils.cleanDirectory((File)pendingDir);
        FileUtils.deleteQuietly((File)new File(patcherHome, "patcher.plan"));
        this.audit(Audit.SYSTEM_UPDATE_CANCELED, new Date(), this.param("autoupdate.audit.version-to", SystemUpdate.systemVersionWithRevision(this.getContext().getTargetPatch())), this.param("autoupdate.audit.version-from", SystemVersion.getVersionIdentifier()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void applyRollback(Rollback rollback) {
        Date started = new Date();
        Validator validator = new Validator(this.context);
        List<Rollback> order = this.rollbacks.resolve(rollback);
        File temp = File.createTempFile("temp", ".patch");
        try {
            try (FileInputStream in = new FileInputStream(order.get(0).resolve(this.context));){
                IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(temp));
            }
            var7_8 = null;
            try (Archive archive = new Archive(temp);){
                archive.open();
                ValidationResult validationResult = validator.validate(archive);
                log.info("Rollback {} validation result: {}", (Object)rollback, (Object)validationResult.toFormattedString());
                if (!validationResult.valid()) {
                    throw new IllegalStateException("Validation failed when rolling back updates");
                }
            }
            catch (Throwable validationResult) {
                var7_8 = validationResult;
                throw validationResult;
            }
            File patcherHome = new File(this.context.getRoot(), ".patcher");
            patcherHome.mkdirs();
            ArrayList<String> rollbcs = new ArrayList<String>();
            for (Rollback rb : order) {
                rollbcs.add(rb.getFileName());
            }
            PatcherPlan plan = PatcherPlan.builder().client(PatcherPlan.ClientContext.builder().environment(this.getEngine().getConfig().getEnvironment()).token(this.getEngine().getConfig().getApiToken()).build()).serverURI(this.getEngine().getConfig().getServerUrl()).version(this.context.getCurrentVersion()).patches(Collections.emptyList()).rollbacks(rollbcs).build();
            plan.save(this.context);
            Resource resource = this.plugin.getResource("patcher.jar");
            File patcherBin = new File(this.context.getRoot(), ".patcher/patcher.jar");
            try (InputStream inputStream = resource.getInputStream();){
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)patcherBin);
            }
            this.audit(Audit.SYSTEM_ROLLBACK_SCHEDULED, started, this.param("autoupdate.audit.version-to", rollback.getTo()), this.param("autoupdate.audit.version-from", rollback.getFrom()), this.param("autoupdate.audit.backup", rollback.getFileName()));
        }
        finally {
            temp.delete();
        }
    }

    @Override
    protected void configureStateMachine(StateMachineConfig<UpdateState, UpdateEvent> config) {
        EnumSet.of(UpdateState.ERROR, UpdateState.INITIAL, UpdateState.UP_TO_DATE, UpdateState.NO_UPDATES, UpdateState.UPDATES_AVAILABLE).forEach(state -> config.configure((Object)state).permit((Object)UpdateEvent.UPLOADED, (Object)UpdateState.VALIDATING));
    }

    @Override
    public ComponentUpdate.ApplyResult apply(InputStream stream) {
        if (this.getStateMachine().canFire((Object)UpdateEvent.UPLOADED)) {
            byte[] bytes = IOUtils.toByteArray((InputStream)stream);
            PatchMeta patch = Archive.readMeta((InputStream)new ByteArrayInputStream(bytes));
            if (!patch.getFromVersion().equals(this.getVersion())) {
                log.info("Invalid version uploaded: {} != {}", (Object)patch.getFromVersion(), (Object)this.getVersion());
                return ComponentUpdate.ApplyResult.invalidVersion(this.getVersion(), patch.getFromVersion());
            }
            this.downloader.upload(patch, new ByteArrayInputStream(bytes));
            this.getContext().setPatchesToApply(Arrays.asList(SystemUpdate.generatedPatch(patch)));
            this.getStateMachine().fire((Object)UpdateEvent.UPLOADED);
            return ComponentUpdate.ApplyResult.ok();
        }
        throw new IllegalStateException("Could not apply now: current state" + this.getStateMachine().getState());
    }

    private static PendingPatch generatedPatch(PatchMeta patch) {
        return new PendingPatch(UUID.fromString(patch.getPatchId()), patch.getFromVersion(), patch.getToVersion(), Collections.emptyMap());
    }

    private static String systemVersionWithRevision(PendingPatch targetPatch) {
        String systemVersion = targetPatch.getProperties().getOrDefault(Props.PLUSWORKFLOW_VERSION.property(), "");
        return systemVersion + "(#" + targetPatch.getToVersion() + ")";
    }

    private Map.Entry<String, Object> param(String key, Object value) {
        return Maps.entry((Object)key, (Object)value);
    }
}

