/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.system;

import com.google.common.base.Preconditions;
import com.google.common.io.PatternFilenameFilter;
import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patch.plusworkflow.archive.Meta;
import com.suncode.autoupdate.patcher.Context;
import com.suncode.autoupdate.plusworkflow.update.system.Rollback;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Rollbacks {
    private static final Logger log = LoggerFactory.getLogger(Rollbacks.class);
    private final Context context;
    private static final PatternFilenameFilter BACKUP = new PatternFilenameFilter(".*\\.backup");

    public List<Rollback> resolve(Rollback rb) {
        List<Rollback> all = this.discover();
        ArrayList<Rollback> result = new ArrayList<Rollback>();
        boolean found = false;
        for (Rollback rollback : all) {
            result.add(rollback);
            if (!rollback.equals(rb)) continue;
            found = true;
            break;
        }
        Preconditions.checkState((boolean)found);
        return result;
    }

    public List<Rollback> discover() {
        Rollback found;
        File backupDir = new File(this.context.getRoot(), ".patcher/backups");
        if (!backupDir.exists()) {
            return Collections.emptyList();
        }
        ArrayList<Rollback> rollbacks = new ArrayList<Rollback>();
        for (File backupFile : backupDir.listFiles((FilenameFilter)BACKUP)) {
            Rollback rollback = this.read(backupFile);
            if (rollback == null) continue;
            rollbacks.add(rollback);
        }
        LinkedHashMap<String, Rollback> filtered = new LinkedHashMap<String, Rollback>();
        String from = this.context.getCurrentVersion();
        while ((found = this.newestRollback(from, rollbacks)) != null && !filtered.containsKey(found.getFileName())) {
            filtered.put(found.getFileName(), found);
            from = found.getTo();
        }
        return new ArrayList<Rollback>(filtered.values());
    }

    private Rollback newestRollback(String fromVersion, Collection<Rollback> rollbacks) {
        Rollback found = null;
        for (Rollback rollback : rollbacks) {
            if (!rollback.getFrom().equals(fromVersion) || found != null && !rollback.getApplied().after(found.getApplied())) continue;
            found = rollback;
        }
        return found;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Rollback read(File file) {
        try (Archive archive = new Archive(file);){
            archive.open();
            Meta meta = archive.getMeta();
            Rollback rollback = Rollback.builder().from(meta.getFromVersion()).to(meta.getToVersion()).fileName(file.getName()).applied(new Date(file.lastModified())).build();
            return rollback;
        }
        catch (Exception e) {
            log.error("Failed to read rollbacks from {}", (Object)file, (Object)e);
            return null;
        }
    }

    @ConstructorProperties(value={"context"})
    @Autowired
    public Rollbacks(Context context) {
        this.context = context;
    }
}

