/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.system;

import com.suncode.autoupdate.plusworkflow.update.Patches;
import com.suncode.autoupdate.server.client.api.Patch;
import com.suncode.pwfl.util.Streams;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

final class InOrderPatches
implements Patches {
    private final String newest;
    private final List<Patch> patches;

    @Override
    public Optional<Patch> get(UUID patchId) {
        return this.patches.stream().filter(patch -> patch.getId().equals(patchId)).findFirst();
    }

    @Override
    public boolean hasAny() {
        return !this.patches.isEmpty();
    }

    @Override
    public Optional<String> getNewestVersion() {
        return Optional.ofNullable(this.newest);
    }

    @Override
    public List<Patch> neededFor(String version) {
        return this.patches.stream().reduce(new Reducer(version), Reducer::reduce, Streams.unsupported()).getPatches();
    }

    @ConstructorProperties(value={"newest", "patches"})
    public InOrderPatches(String newest, List<Patch> patches) {
        this.newest = newest;
        this.patches = patches;
    }

    public String getNewest() {
        return this.newest;
    }

    public List<Patch> getPatches() {
        return this.patches;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InOrderPatches)) {
            return false;
        }
        InOrderPatches other = (InOrderPatches)o;
        String this$newest = this.getNewest();
        String other$newest = other.getNewest();
        if (this$newest == null ? other$newest != null : !this$newest.equals(other$newest)) {
            return false;
        }
        List<Patch> this$patches = this.getPatches();
        List<Patch> other$patches = other.getPatches();
        return !(this$patches == null ? other$patches != null : !((Object)this$patches).equals(other$patches));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $newest = this.getNewest();
        result = result * 59 + ($newest == null ? 43 : $newest.hashCode());
        List<Patch> $patches = this.getPatches();
        result = result * 59 + ($patches == null ? 43 : ((Object)$patches).hashCode());
        return result;
    }

    public String toString() {
        return "InOrderPatches(newest=" + this.getNewest() + ", patches=" + this.getPatches() + ")";
    }

    private class Reducer {
        private final String target;
        private boolean found;
        private final List<Patch> patches = new ArrayList<Patch>();

        Reducer reduce(Patch patch) {
            if (!this.found) {
                this.patches.add(patch);
                if (patch.getToVersion().equals(this.target)) {
                    this.found = true;
                }
            }
            return this;
        }

        @ConstructorProperties(value={"target"})
        public Reducer(String target) {
            this.target = target;
        }

        public List<Patch> getPatches() {
            return this.patches;
        }
    }
}

