/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.suncode.autoupdate.plusworkflow.update.Patches;
import com.suncode.autoupdate.plusworkflow.update.PendingPatch;
import com.suncode.autoupdate.plusworkflow.update.system.Rollback;
import com.suncode.autoupdate.plusworkflow.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UpdateContext {
    private Date lastCheck;
    private Patches patches;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private List<PendingPatch> patchesToApply;
    private Date applyAfter;
    private Rollback rollback;

    public Patches getPatches() {
        return Optional.ofNullable(this.patches).orElseGet(Patches.NoPatches::new);
    }

    @JsonIgnore
    public Optional<String> getNewestVersion() {
        return this.getPatches().getNewestVersion();
    }

    @JsonIgnore
    public PendingPatch getTargetPatch() {
        Preconditions.checkState((!this.patchesToApply.isEmpty() ? 1 : 0) != 0);
        return Collections.last(this.patchesToApply);
    }

    public Date getLastCheck() {
        return this.lastCheck;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public List<PendingPatch> getPatchesToApply() {
        return this.patchesToApply;
    }

    public Date getApplyAfter() {
        return this.applyAfter;
    }

    public Rollback getRollback() {
        return this.rollback;
    }

    public void setLastCheck(Date lastCheck) {
        this.lastCheck = lastCheck;
    }

    public void setPatches(Patches patches) {
        this.patches = patches;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setPatchesToApply(List<PendingPatch> patchesToApply) {
        this.patchesToApply = patchesToApply;
    }

    public void setApplyAfter(Date applyAfter) {
        this.applyAfter = applyAfter;
    }

    public void setRollback(Rollback rollback) {
        this.rollback = rollback;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateContext)) {
            return false;
        }
        UpdateContext other = (UpdateContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$lastCheck = this.getLastCheck();
        Date other$lastCheck = other.getLastCheck();
        if (this$lastCheck == null ? other$lastCheck != null : !((Object)this$lastCheck).equals(other$lastCheck)) {
            return false;
        }
        Patches this$patches = this.getPatches();
        Patches other$patches = other.getPatches();
        if (this$patches == null ? other$patches != null : !this$patches.equals(other$patches)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<PendingPatch> this$patchesToApply = this.getPatchesToApply();
        List<PendingPatch> other$patchesToApply = other.getPatchesToApply();
        if (this$patchesToApply == null ? other$patchesToApply != null : !((Object)this$patchesToApply).equals(other$patchesToApply)) {
            return false;
        }
        Date this$applyAfter = this.getApplyAfter();
        Date other$applyAfter = other.getApplyAfter();
        if (this$applyAfter == null ? other$applyAfter != null : !((Object)this$applyAfter).equals(other$applyAfter)) {
            return false;
        }
        Rollback this$rollback = this.getRollback();
        Rollback other$rollback = other.getRollback();
        return !(this$rollback == null ? other$rollback != null : !((Object)this$rollback).equals(other$rollback));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $lastCheck = this.getLastCheck();
        result = result * 59 + ($lastCheck == null ? 43 : ((Object)$lastCheck).hashCode());
        Patches $patches = this.getPatches();
        result = result * 59 + ($patches == null ? 43 : $patches.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<PendingPatch> $patchesToApply = this.getPatchesToApply();
        result = result * 59 + ($patchesToApply == null ? 43 : ((Object)$patchesToApply).hashCode());
        Date $applyAfter = this.getApplyAfter();
        result = result * 59 + ($applyAfter == null ? 43 : ((Object)$applyAfter).hashCode());
        Rollback $rollback = this.getRollback();
        result = result * 59 + ($rollback == null ? 43 : ((Object)$rollback).hashCode());
        return result;
    }

    public String toString() {
        return "UpdateContext(lastCheck=" + this.getLastCheck() + ", patches=" + this.getPatches() + ", properties=" + this.getProperties() + ", patchesToApply=" + this.getPatchesToApply() + ", applyAfter=" + this.getApplyAfter() + ", rollback=" + this.getRollback() + ")";
    }
}

