/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.support;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.delegates.Func;
import com.suncode.autoupdate.plusworkflow.update.UpdateState;
import com.suncode.autoupdate.plusworkflow.update.support.UpdateContext;
import com.suncode.autoupdate.plusworkflow.util.Safe;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.EnumSet;

public class PersistState
implements Func<UpdateState>,
Action1<UpdateState> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new Jdk8Module());
    private final PluginStore store;
    private Serialized state;

    public PersistState(PluginStore store) {
        this.store = store;
        this.state = this.load();
    }

    public UpdateContext getPersistedContext() {
        return this.state.context;
    }

    public void doIt(UpdateState arg1) {
        this.state.state = arg1;
        this.persist();
    }

    public UpdateState call() {
        return this.state.state;
    }

    private void persist() {
        EnumSet<UpdateState> persistent = EnumSet.of(UpdateState.POSTPONED_BACKUP, UpdateState.POSTPONED_UPDATE);
        if (persistent.contains((Object)this.state.state)) {
            byte[] bytes = OBJECT_MAPPER.writeValueAsBytes((Object)this.state);
            this.store.store("state", (InputStream)new ByteArrayInputStream(bytes), true);
        }
    }

    private Serialized load() {
        PluginStoreResource read = this.store.read("state");
        if (read == null) {
            return new Serialized();
        }
        return Safe.safeNoLog(() -> {
            try (InputStream in = read.getInputStream();){
                Serialized serialized = (Serialized)OBJECT_MAPPER.readValue(in, Serialized.class);
                return serialized;
            }
        }, new Serialized());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Serialized {
        UpdateContext context = new UpdateContext();
        UpdateState state = UpdateState.INITIAL;

        private Serialized() {
        }

        public UpdateContext getContext() {
            return this.context;
        }

        public UpdateState getState() {
            return this.state;
        }

        public void setContext(UpdateContext context) {
            this.context = context;
        }

        public void setState(UpdateState state) {
            this.state = state;
        }
    }
}

