/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.support;

import com.github.oxo42.stateless4j.StateMachine;
import com.github.oxo42.stateless4j.StateMachineConfig;
import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.delegates.Func;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters1;
import com.google.common.base.Preconditions;
import com.suncode.autoupdate.patch.plusworkflow.archive.ArchiveUtils;
import com.suncode.autoupdate.patch.plusworkflow.archive.Index;
import com.suncode.autoupdate.plusworkflow.update.Patches;
import com.suncode.autoupdate.plusworkflow.update.PendingPatch;
import com.suncode.autoupdate.plusworkflow.update.UpdateEvent;
import com.suncode.autoupdate.plusworkflow.update.UpdateState;
import com.suncode.autoupdate.plusworkflow.update.Updates;
import com.suncode.autoupdate.plusworkflow.update.download.Download;
import com.suncode.autoupdate.plusworkflow.update.download.DownloadQueue;
import com.suncode.autoupdate.plusworkflow.update.download.Downloads;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdate;
import com.suncode.autoupdate.plusworkflow.update.engine.UpdateEngine;
import com.suncode.autoupdate.plusworkflow.update.support.AbstractAction;
import com.suncode.autoupdate.plusworkflow.update.support.PersistState;
import com.suncode.autoupdate.plusworkflow.update.support.StateSummaryMapper;
import com.suncode.autoupdate.plusworkflow.update.support.UpdateContext;
import com.suncode.autoupdate.plusworkflow.update.system.Rollback;
import com.suncode.autoupdate.plusworkflow.util.Consumer;
import com.suncode.autoupdate.plusworkflow.util.Safe;
import com.suncode.autoupdate.server.client.UpdateServerClient;
import com.suncode.autoupdate.server.client.api.Patch;
import com.suncode.autoupdate.server.client.api.Project;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponentUpdate
implements ComponentUpdate {
    private static final Logger log = LoggerFactory.getLogger(AbstractComponentUpdate.class);
    private final UpdateEngine engine;
    private final UpdateContext context;
    private final DownloadQueue downloadQueue;
    private final StateMachine<UpdateState, UpdateEvent> stateMachine;
    protected final StateSummaryMapper summaryMapper;
    private final Downloads downloads;
    private static final TriggerWithParameters1<Throwable, UpdateState, UpdateEvent> ERROR_TRIGGER = new TriggerWithParameters1((Object)UpdateEvent.ERROR_OCCURRED, Throwable.class);
    private static final TriggerWithParameters1<String, UpdateState, UpdateEvent> DOWNLOAD_TRIGGER = new TriggerWithParameters1((Object)UpdateEvent.DOWNLOAD_UPDATES, String.class);

    public AbstractComponentUpdate(PluginStore store, UpdateEngine engine, DownloadQueue downloadQueue, StateSummaryMapper summaryMapper) {
        this.engine = engine;
        this.downloadQueue = downloadQueue;
        this.summaryMapper = summaryMapper;
        this.downloads = new Downloads(store);
        if (this.persistentState()) {
            PersistState state = new PersistState(store);
            this.context = state.getPersistedContext();
            this.stateMachine = this.setup(state);
        } else {
            this.context = new UpdateContext();
            this.stateMachine = this.setup(null);
        }
    }

    protected StateMachine<UpdateState, UpdateEvent> setup(PersistState persistState) {
        StateMachineConfig config = new StateMachineConfig();
        config.configure((Object)UpdateState.ERROR).permit((Object)UpdateEvent.CHECK, (Object)UpdateState.CHECKING);
        config.configure((Object)UpdateState.INITIAL).permit((Object)UpdateEvent.CHECK, (Object)UpdateState.CHECKING).onEntry(() -> {
            if (this.engine.isConfigured()) {
                this.stateMachine.fire((Object)UpdateEvent.CHECK);
            }
        });
        config.configure((Object)UpdateState.CHECKING).onEntry((Action1)new CheckAction()).permit((Object)UpdateEvent.CHECK_NO_UPDATES, (Object)UpdateState.UP_TO_DATE).permit((Object)UpdateEvent.CHECK_UPDATES_AVAILABLE, (Object)UpdateState.UPDATES_AVAILABLE).permit((Object)UpdateEvent.CHECK_NO_CHANNEL, (Object)UpdateState.NO_UPDATES);
        config.configure((Object)UpdateState.UPDATES_AVAILABLE).onEntryFrom((Object)UpdateEvent.APPLIED_NOT_NEWEST, this::check).permit((Object)UpdateEvent.CHECK, (Object)UpdateState.CHECKING).permit((Object)UpdateEvent.DOWNLOAD_UPDATES, (Object)UpdateState.DOWNLOADING).permit((Object)UpdateEvent.RESTORE_BACKUP, (Object)UpdateState.APPLYING_BACKUP);
        config.configure((Object)UpdateState.UP_TO_DATE).onEntryFrom((Object)UpdateEvent.APPLIED_NEWEST, this::check).permit((Object)UpdateEvent.CHECK, (Object)UpdateState.CHECKING).permit((Object)UpdateEvent.DOWNLOAD_UPDATES, (Object)UpdateState.DOWNLOADING).permit((Object)UpdateEvent.RESTORE_BACKUP, (Object)UpdateState.APPLYING_BACKUP);
        config.configure((Object)UpdateState.NO_UPDATES).permit((Object)UpdateEvent.CHECK, (Object)UpdateState.CHECKING);
        config.configure((Object)UpdateState.DOWNLOADING).onEntryFrom(DOWNLOAD_TRIGGER, (Action1)new DownloadAction(), String.class).permit((Object)UpdateEvent.DOWNLOAD_COMPLETED, (Object)UpdateState.DOWNLOADED);
        if (this.needsValidation()) {
            config.configure((Object)UpdateState.DOWNLOADED).onEntry(() -> this.stateMachine.fire((Object)UpdateEvent.APPLY)).permit((Object)UpdateEvent.APPLY, (Object)UpdateState.VALIDATING);
            config.configure((Object)UpdateState.VALIDATING).onEntry((com.github.oxo42.stateless4j.delegates.Action)new ValidateAction()).permit((Object)UpdateEvent.VALIDATION_SUCCESS, (Object)UpdateState.READY).permit((Object)UpdateEvent.VALIDATION_ERROR, (Object)UpdateState.VALIDATED_ERROR);
            config.configure((Object)UpdateState.VALIDATED_ERROR).permit((Object)UpdateEvent.CONFIRM, (Object)UpdateState.APPLYING).permit((Object)UpdateEvent.CANCEL, (Object)UpdateState.INITIAL);
        } else {
            config.configure((Object)UpdateState.DOWNLOADED).onEntry(() -> this.stateMachine.fire((Object)UpdateEvent.APPLY)).permit((Object)UpdateEvent.APPLY, (Object)UpdateState.READY);
        }
        config.configure((Object)UpdateState.READY).permit((Object)UpdateEvent.CONFIRM, (Object)UpdateState.APPLYING).permit((Object)UpdateEvent.CANCEL, (Object)UpdateState.INITIAL);
        if (this.autoConfirm()) {
            config.configure((Object)UpdateState.READY).onEntry(() -> this.stateMachine.fire((Object)UpdateEvent.CONFIRM));
        }
        config.configure((Object)UpdateState.APPLYING).onEntry((Action1)new ApplyAction()).permit((Object)UpdateEvent.APPLIED_POSTPONE, (Object)UpdateState.POSTPONED_UPDATE).permit((Object)UpdateEvent.APPLIED_NEWEST, (Object)UpdateState.UP_TO_DATE).permit((Object)UpdateEvent.APPLIED_NOT_NEWEST, (Object)UpdateState.UPDATES_AVAILABLE);
        config.configure((Object)UpdateState.POSTPONED_UPDATE).onExit((Action1)new ExitPostPonedAction()).permit((Object)UpdateEvent.CANCEL, (Object)UpdateState.INITIAL);
        config.configure((Object)UpdateState.APPLYING_BACKUP).onEntry((Action1)new ApplyBackupAction()).permit((Object)UpdateEvent.RESTORE_BACKUP, (Object)UpdateState.POSTPONED_BACKUP);
        config.configure((Object)UpdateState.POSTPONED_BACKUP).onExit((Action1)new ExitPostPonedAction()).permit((Object)UpdateEvent.CANCEL, (Object)UpdateState.INITIAL);
        for (UpdateState state : UpdateState.values()) {
            if (state == UpdateState.ERROR) continue;
            config.configure((Object)state).permit((Object)UpdateEvent.ERROR_OCCURRED, (Object)UpdateState.ERROR);
        }
        this.configureStateMachine((StateMachineConfig<UpdateState, UpdateEvent>)config);
        if (persistState != null) {
            return new StateMachine((Object)persistState.call(), (Func)persistState, (Action1)persistState, config);
        }
        return new StateMachine((Object)UpdateState.INITIAL, config);
    }

    protected void configureStateMachine(StateMachineConfig<UpdateState, UpdateEvent> config) {
    }

    @Override
    public Updates getUpdates() {
        return Updates.builder().name(this.getProjectName()).displayName(this.getProjectDisplayName()).channel(this.getChannelName()).currentVersion(this.getVersion()).newestVersion(this.context.getNewestVersion().orElse(null)).stateSummary(this.summaryMapper.summaryOf(this.state(), this.context)).state(this.state()).lastCheck(this.context.getLastCheck()).updates(this.context.getPatches()).pendingPatches(this.context.getPatchesToApply()).properties(this.context.getProperties()).build();
    }

    @Override
    public final UpdateState state() {
        return (UpdateState)((Object)this.stateMachine.getState());
    }

    protected void error(Throwable error) {
        if (this.stateMachine.canFire((Object)UpdateEvent.ERROR_OCCURRED)) {
            this.stateMachine.fire(ERROR_TRIGGER, (Object)error);
        }
    }

    protected abstract boolean needsValidation();

    protected abstract boolean autoConfirm();

    protected abstract boolean persistentState();

    protected abstract String getProjectName();

    protected abstract String getProjectDisplayName();

    protected abstract String getChannelName();

    protected abstract String getVersion();

    protected abstract boolean validate(List<PendingPatch> var1, Downloads var2);

    protected abstract boolean applyUpdates(List<PendingPatch> var1, Downloads var2);

    protected abstract void applyRollback(Rollback var1);

    protected abstract Patches getAvailablePatches(UpdateServerClient var1);

    protected void cancelPostPoned() {
    }

    protected Index readIndex(PendingPatch patch) {
        PluginStoreResource resource = this.downloads.patchArchive(patch);
        Preconditions.checkNotNull((Object)resource, (String)"Patch %s was not yet downloaded", (Object)patch);
        return Safe.withInputStream(resource, ArchiveUtils::readIndex);
    }

    @Override
    public void check() {
        if (this.stateMachine.canFire((Object)UpdateEvent.CHECK)) {
            this.stateMachine.fire((Object)UpdateEvent.CHECK);
        }
    }

    @Override
    public void updateTo(String version) {
        if (this.stateMachine.canFire((Object)UpdateEvent.DOWNLOAD_UPDATES)) {
            this.stateMachine.fire(DOWNLOAD_TRIGGER, (Object)version);
        }
    }

    @Override
    public void confirm(Date when) {
        if (this.stateMachine.canFire((Object)UpdateEvent.CONFIRM)) {
            this.context.setApplyAfter(when);
            this.stateMachine.fire((Object)UpdateEvent.CONFIRM);
        }
    }

    @Override
    public void cancel() {
        this.stateMachine.fire((Object)UpdateEvent.CANCEL);
    }

    @Override
    public void rollback(Rollback rollback) {
        this.context.setRollback(rollback);
        this.stateMachine.fire((Object)UpdateEvent.RESTORE_BACKUP);
    }

    public UpdateEngine getEngine() {
        return this.engine;
    }

    public UpdateContext getContext() {
        return this.context;
    }

    public StateMachine<UpdateState, UpdateEvent> getStateMachine() {
        return this.stateMachine;
    }

    protected abstract class Action
    extends AbstractAction {
        public Action() {
            super(new Consumer<Throwable>(){

                @Override
                public void accept(Throwable error) {
                    if (AbstractComponentUpdate.this.stateMachine.canFire((Object)UpdateEvent.ERROR_OCCURRED)) {
                        AbstractComponentUpdate.this.stateMachine.fire(ERROR_TRIGGER, (Object)error);
                    }
                }
            });
        }
    }

    private class ExitPostPonedAction
    extends Action {
        private ExitPostPonedAction() {
        }

        @Override
        protected void run(UpdateState from, UpdateState to, UpdateEvent trigger) {
            AbstractComponentUpdate.this.cancelPostPoned();
        }
    }

    private class ApplyBackupAction
    extends Action {
        private ApplyBackupAction() {
        }

        @Override
        protected void run(UpdateState from, UpdateState to, UpdateEvent trigger) {
            AbstractComponentUpdate.this.applyRollback(AbstractComponentUpdate.this.context.getRollback());
            AbstractComponentUpdate.this.stateMachine.fire((Object)UpdateEvent.RESTORE_BACKUP);
        }
    }

    private class ApplyAction
    extends Action {
        private ApplyAction() {
        }

        @Override
        protected void run(UpdateState from, UpdateState to, UpdateEvent trigger) {
            if (!AbstractComponentUpdate.this.applyUpdates(AbstractComponentUpdate.this.context.getPatchesToApply(), AbstractComponentUpdate.this.downloads)) {
                if (AbstractComponentUpdate.this.getVersion().equals(AbstractComponentUpdate.this.context.getNewestVersion().orElse(null))) {
                    AbstractComponentUpdate.this.stateMachine.fire((Object)UpdateEvent.APPLIED_NEWEST);
                } else {
                    AbstractComponentUpdate.this.stateMachine.fire((Object)UpdateEvent.APPLIED_NOT_NEWEST);
                }
            }
        }
    }

    private class ValidateAction
    implements com.github.oxo42.stateless4j.delegates.Action {
        private ValidateAction() {
        }

        public void doIt() {
            block4: {
                try {
                    if (AbstractComponentUpdate.this.validate(AbstractComponentUpdate.this.context.getPatchesToApply(), AbstractComponentUpdate.this.downloads)) {
                        AbstractComponentUpdate.this.stateMachine.fire((Object)UpdateEvent.VALIDATION_SUCCESS);
                    } else {
                        AbstractComponentUpdate.this.stateMachine.fire((Object)UpdateEvent.VALIDATION_ERROR);
                    }
                }
                catch (Throwable t) {
                    log.error("Error when validating update", t);
                    if (!AbstractComponentUpdate.this.stateMachine.canFire((Object)UpdateEvent.ERROR_OCCURRED)) break block4;
                    AbstractComponentUpdate.this.stateMachine.fire(ERROR_TRIGGER, (Object)t);
                }
            }
        }
    }

    private class DownloadAction
    implements Action1<String> {
        private DownloadAction() {
        }

        public void doIt(String version) {
            block3: {
                try {
                    List<Patch> patches = AbstractComponentUpdate.this.context.getPatches().neededFor(version);
                    if (patches.isEmpty()) {
                        throw new IllegalStateException("No patch to version [" + version + "] found");
                    }
                    AbstractComponentUpdate.this.context.setPatchesToApply(PendingPatch.map(patches));
                    Download download = AbstractComponentUpdate.this.downloadQueue.schedule(patches, AbstractComponentUpdate.this.engine.getClient());
                    download.await();
                    AbstractComponentUpdate.this.stateMachine.fire((Object)UpdateEvent.DOWNLOAD_COMPLETED);
                }
                catch (Throwable t) {
                    log.error("Error when downloading updates", t);
                    if (!AbstractComponentUpdate.this.stateMachine.canFire((Object)UpdateEvent.ERROR_OCCURRED)) break block3;
                    AbstractComponentUpdate.this.stateMachine.fire(ERROR_TRIGGER, (Object)t);
                }
            }
        }
    }

    private class CheckAction
    extends Action {
        private CheckAction() {
        }

        @Override
        protected void run(UpdateState from, UpdateState to, UpdateEvent trigger) {
            UpdateServerClient client = AbstractComponentUpdate.this.engine.getClient();
            AbstractComponentUpdate.this.context.setLastCheck(new Date());
            log.info("Checking for updates {}@{}:{}", new Object[]{AbstractComponentUpdate.this.getProjectName(), AbstractComponentUpdate.this.getChannelName(), AbstractComponentUpdate.this.getVersion()});
            Project project = this.findProject(client);
            if (project == null) {
                log.info("Project {} not found", (Object)AbstractComponentUpdate.this.getProjectName());
                AbstractComponentUpdate.this.stateMachine.fire((Object)UpdateEvent.CHECK_NO_CHANNEL);
                return;
            }
            if (!project.getChannels().contains(AbstractComponentUpdate.this.getChannelName())) {
                log.info("Channel {} not found in project {}", (Object)AbstractComponentUpdate.this.getChannelName(), (Object)AbstractComponentUpdate.this.getProjectName());
                AbstractComponentUpdate.this.stateMachine.fire((Object)UpdateEvent.CHECK_NO_CHANNEL);
                return;
            }
            AbstractComponentUpdate.this.context.setPatches(AbstractComponentUpdate.this.getAvailablePatches(client));
            if (AbstractComponentUpdate.this.context.getPatches().hasAny()) {
                AbstractComponentUpdate.this.stateMachine.fire((Object)UpdateEvent.CHECK_UPDATES_AVAILABLE);
            } else {
                AbstractComponentUpdate.this.stateMachine.fire((Object)UpdateEvent.CHECK_NO_UPDATES);
            }
        }

        private Project findProject(UpdateServerClient client) {
            for (Project project : client.projects().getProjects()) {
                if (!project.getName().equals(AbstractComponentUpdate.this.getProjectName())) continue;
                return project;
            }
            return null;
        }
    }
}

