/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.plugin;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginControl;
import com.suncode.plugin.framework.Reference;
import com.suncode.plugin.framework.Version;
import com.suncode.plugin.framework.requirements.Provided;
import com.suncode.plugin.framework.requirements.Required;
import com.suncode.plugin.framework.requirements.Requirement;
import com.suncode.plugin.framework.requirements.Resolution;
import com.suncode.pwfl.util.Predicates;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class ValidationView {
    private final MandatoryOrOptional missing;
    private final MandatoryOrOptional provided;

    public ValidationView(PluginControl.Validation validation) {
        this.missing = new MandatoryOrOptional(validation.getRequired().stream().map(Mismatch::of).collect(Collectors.toSet()));
        this.provided = new MandatoryOrOptional(validation.getProvided().stream().map(Mismatch::of).collect(Collectors.toSet()));
    }

    public boolean isValid() {
        return this.missing.items.isEmpty() && this.provided.items.isEmpty();
    }

    public MandatoryOrOptional getMissing() {
        return this.missing;
    }

    public MandatoryOrOptional getProvided() {
        return this.provided;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationView)) {
            return false;
        }
        ValidationView other = (ValidationView)o;
        MandatoryOrOptional this$missing = this.getMissing();
        MandatoryOrOptional other$missing = other.getMissing();
        if (this$missing == null ? other$missing != null : !((Object)this$missing).equals(other$missing)) {
            return false;
        }
        MandatoryOrOptional this$provided = this.getProvided();
        MandatoryOrOptional other$provided = other.getProvided();
        return !(this$provided == null ? other$provided != null : !((Object)this$provided).equals(other$provided));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MandatoryOrOptional $missing = this.getMissing();
        result = result * 59 + ($missing == null ? 43 : ((Object)$missing).hashCode());
        MandatoryOrOptional $provided = this.getProvided();
        result = result * 59 + ($provided == null ? 43 : ((Object)$provided).hashCode());
        return result;
    }

    public String toString() {
        return "ValidationView(missing=" + this.getMissing() + ", provided=" + this.getProvided() + ")";
    }

    public static final class Mismatch {
        private final String key;
        private final List<Version> requiredVersions;
        private final Resolution resolution;
        private final boolean mandatory;

        public static Mismatch of(Required required) {
            Requirement requirement = required.getRequirement();
            return new Mismatch(requirement.getPluginKey(), requirement.getRequiredVersions(), required.getResolution(), requirement.isMandatory());
        }

        public static Mismatch of(Provided provided) {
            Reference ref = Reference.of((Plugin)provided.getPlugin());
            return new Mismatch(ref.getId(), provided.getRequired().getRequirement().getRequiredVersions(), provided.getRequired().getResolution(), provided.getRequired().getRequirement().isMandatory());
        }

        @ConstructorProperties(value={"key", "requiredVersions", "resolution", "mandatory"})
        public Mismatch(String key, List<Version> requiredVersions, Resolution resolution, boolean mandatory) {
            this.key = key;
            this.requiredVersions = requiredVersions;
            this.resolution = resolution;
            this.mandatory = mandatory;
        }

        public String getKey() {
            return this.key;
        }

        public List<Version> getRequiredVersions() {
            return this.requiredVersions;
        }

        public Resolution getResolution() {
            return this.resolution;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mismatch)) {
                return false;
            }
            Mismatch other = (Mismatch)o;
            if (this.isMandatory() != other.isMandatory()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            List<Version> this$requiredVersions = this.getRequiredVersions();
            List<Version> other$requiredVersions = other.getRequiredVersions();
            if (this$requiredVersions == null ? other$requiredVersions != null : !((Object)this$requiredVersions).equals(other$requiredVersions)) {
                return false;
            }
            Resolution this$resolution = this.getResolution();
            Resolution other$resolution = other.getResolution();
            return !(this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMandatory() ? 79 : 97);
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            List<Version> $requiredVersions = this.getRequiredVersions();
            result = result * 59 + ($requiredVersions == null ? 43 : ((Object)$requiredVersions).hashCode());
            Resolution $resolution = this.getResolution();
            result = result * 59 + ($resolution == null ? 43 : $resolution.hashCode());
            return result;
        }

        public String toString() {
            return "ValidationView.Mismatch(key=" + this.getKey() + ", requiredVersions=" + this.getRequiredVersions() + ", resolution=" + this.getResolution() + ", mandatory=" + this.isMandatory() + ")";
        }
    }

    public static final class MandatoryOrOptional {
        private final Set<Mismatch> items;

        public Set<Mismatch> getMandatory() {
            return this.items.stream().filter(Mismatch::isMandatory).collect(Collectors.toSet());
        }

        public Set<Mismatch> getOptional() {
            return this.items.stream().filter(Predicates.not(Mismatch::isMandatory)).collect(Collectors.toSet());
        }

        @ConstructorProperties(value={"items"})
        public MandatoryOrOptional(Set<Mismatch> items) {
            this.items = items;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MandatoryOrOptional)) {
                return false;
            }
            MandatoryOrOptional other = (MandatoryOrOptional)o;
            Set<Mismatch> this$items = this.items;
            Set<Mismatch> other$items = other.items;
            return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Mismatch> $items = this.items;
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            return result;
        }

        public String toString() {
            return "ValidationView.MandatoryOrOptional(items=" + this.items + ")";
        }
    }
}

