/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdate;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdater;
import com.suncode.autoupdate.plusworkflow.update.plugin.PluginUpdate;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginFramework;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class PluginsUpdater
implements ComponentUpdater,
Ordered {
    public static final String RELEASE_CHANNEL = "release";
    private final PluginFramework plugins;
    private final PluginUpdate.Factory factory;
    private final ConcurrentMap<String, PluginUpdate> pluginUpdates = Maps.newConcurrentMap();

    public int getOrder() {
        return 2;
    }

    @Override
    public Collection<ComponentUpdate> getComponents() {
        this.sync();
        return Lists.newArrayList(this.pluginUpdates.values());
    }

    private void sync() {
        for (Object plugin : this.plugins.getPlugins()) {
            if (this.pluginUpdates.containsKey(plugin.getKey())) continue;
            this.pluginUpdates.putIfAbsent(plugin.getKey(), this.factory.releaseChannel((Plugin)plugin));
        }
        for (Object plugin : this.pluginUpdates.keySet()) {
            if (this.plugins.isInstalled((String)plugin)) continue;
            this.pluginUpdates.remove(plugin);
        }
    }

    @ConstructorProperties(value={"plugins", "factory"})
    @Autowired
    public PluginsUpdater(PluginFramework plugins, PluginUpdate.Factory factory) {
        this.plugins = plugins;
        this.factory = factory;
    }
}

