/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.plugin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.suncode.autoupdate.plusworkflow.update.Patches;
import com.suncode.autoupdate.plusworkflow.update.plugin.ValidationView;
import com.suncode.autoupdate.server.client.api.Patch;
import com.suncode.pwfl.util.Streams;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class PluginUpdates
implements Patches {
    private final Patch newest;
    private final List<Patch> updates;
    private final List<Patch> downgrades;
    private final Function<Patch, Validated> validator;

    public List<Validated> getUpdates() {
        return this.updates.stream().map(this.validator).collect(Collectors.toList());
    }

    public List<Validated> getDowngrades() {
        return this.downgrades.stream().map(this.validator).collect(Collectors.toList());
    }

    @Override
    public Optional<Patch> get(UUID patchId) {
        return Stream.concat(this.updates.stream(), this.downgrades.stream()).filter(patch -> patch.getId().equals(patchId)).findFirst();
    }

    @Override
    public boolean hasAny() {
        return !this.updates.isEmpty();
    }

    @Override
    public Optional<String> getNewestVersion() {
        return this.getUpdates().stream().filter(Validated::isValid).findFirst().map(Validated::getToVersion);
    }

    @Override
    public List<Patch> neededFor(String version) {
        return Stream.of(this.updates, this.downgrades).flatMap(Collection::stream).filter(patch -> patch.getToVersion().equals(version)).limit(1L).reduce(Streams.noMoreThanOne()).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    @ConstructorProperties(value={"newest", "updates", "downgrades", "validator"})
    public PluginUpdates(Patch newest, List<Patch> updates, List<Patch> downgrades, Function<Patch, Validated> validator) {
        this.newest = newest;
        this.updates = updates;
        this.downgrades = downgrades;
        this.validator = validator;
    }

    public Patch getNewest() {
        return this.newest;
    }

    public Function<Patch, Validated> getValidator() {
        return this.validator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginUpdates)) {
            return false;
        }
        PluginUpdates other = (PluginUpdates)o;
        Patch this$newest = this.getNewest();
        Patch other$newest = other.getNewest();
        if (this$newest == null ? other$newest != null : !this$newest.equals(other$newest)) {
            return false;
        }
        List<Validated> this$updates = this.getUpdates();
        List<Validated> other$updates = other.getUpdates();
        if (this$updates == null ? other$updates != null : !((Object)this$updates).equals(other$updates)) {
            return false;
        }
        List<Validated> this$downgrades = this.getDowngrades();
        List<Validated> other$downgrades = other.getDowngrades();
        if (this$downgrades == null ? other$downgrades != null : !((Object)this$downgrades).equals(other$downgrades)) {
            return false;
        }
        Function<Patch, Validated> this$validator = this.getValidator();
        Function<Patch, Validated> other$validator = other.getValidator();
        return !(this$validator == null ? other$validator != null : !this$validator.equals(other$validator));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Patch $newest = this.getNewest();
        result = result * 59 + ($newest == null ? 43 : $newest.hashCode());
        List<Validated> $updates = this.getUpdates();
        result = result * 59 + ($updates == null ? 43 : ((Object)$updates).hashCode());
        List<Validated> $downgrades = this.getDowngrades();
        result = result * 59 + ($downgrades == null ? 43 : ((Object)$downgrades).hashCode());
        Function<Patch, Validated> $validator = this.getValidator();
        result = result * 59 + ($validator == null ? 43 : $validator.hashCode());
        return result;
    }

    public String toString() {
        return "PluginUpdates(newest=" + this.getNewest() + ", updates=" + this.getUpdates() + ", downgrades=" + this.getDowngrades() + ", validator=" + this.getValidator() + ")";
    }

    public static final class Validated {
        private final Patch patch;
        private final ValidationView validation;

        @JsonInclude
        public boolean isValid() {
            return this.validation.isValid();
        }

        @ConstructorProperties(value={"patch", "validation"})
        public Validated(Patch patch, ValidationView validation) {
            this.patch = patch;
            this.validation = validation;
        }

        public ValidationView getValidation() {
            return this.validation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Validated)) {
                return false;
            }
            Validated other = (Validated)o;
            Patch this$patch = this.getPatch();
            Patch other$patch = other.getPatch();
            if (this$patch == null ? other$patch != null : !this$patch.equals(other$patch)) {
                return false;
            }
            ValidationView this$validation = this.getValidation();
            ValidationView other$validation = other.getValidation();
            return !(this$validation == null ? other$validation != null : !((Object)this$validation).equals(other$validation));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Patch $patch = this.getPatch();
            result = result * 59 + ($patch == null ? 43 : $patch.hashCode());
            ValidationView $validation = this.getValidation();
            result = result * 59 + ($validation == null ? 43 : ((Object)$validation).hashCode());
            return result;
        }

        public String toString() {
            return "PluginUpdates.Validated(patch=" + this.getPatch() + ", validation=" + this.getValidation() + ")";
        }

        @JsonIgnore
        public Patch getPatch() {
            return this.patch;
        }

        public UUID getId() {
            return this.getPatch().getId();
        }

        public String getFromVersion() {
            return this.getPatch().getFromVersion();
        }

        public String getToVersion() {
            return this.getPatch().getToVersion();
        }

        public Date getUploaded() {
            return this.getPatch().getUploaded();
        }

        public String getChecksum() {
            return this.getPatch().getChecksum();
        }

        public Map<String, String> getProperties() {
            return this.getPatch().getProperties();
        }

        public void setId(UUID id) {
            this.getPatch().setId(id);
        }

        public void setFromVersion(String fromVersion) {
            this.getPatch().setFromVersion(fromVersion);
        }

        public void setToVersion(String toVersion) {
            this.getPatch().setToVersion(toVersion);
        }

        public void setUploaded(Date uploaded) {
            this.getPatch().setUploaded(uploaded);
        }

        public void setChecksum(String checksum) {
            this.getPatch().setChecksum(checksum);
        }

        public void setProperties(Map<String, String> properties) {
            this.getPatch().setProperties(properties);
        }
    }
}

