/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.suncode.autoupdate.patch.plugin.PluginPatchProperties;
import com.suncode.autoupdate.plusworkflow.update.Changelog;
import com.suncode.autoupdate.plusworkflow.update.Patches;
import com.suncode.autoupdate.plusworkflow.update.PendingPatch;
import com.suncode.autoupdate.plusworkflow.update.download.DownloadQueue;
import com.suncode.autoupdate.plusworkflow.update.download.Downloads;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdate;
import com.suncode.autoupdate.plusworkflow.update.engine.UpdateEngine;
import com.suncode.autoupdate.plusworkflow.update.plugin.PluginUpdates;
import com.suncode.autoupdate.plusworkflow.update.plugin.ValidationView;
import com.suncode.autoupdate.plusworkflow.update.support.AbstractComponentUpdate;
import com.suncode.autoupdate.plusworkflow.update.support.StateSummaryMapper;
import com.suncode.autoupdate.plusworkflow.update.system.Rollback;
import com.suncode.autoupdate.plusworkflow.util.Exceptions;
import com.suncode.autoupdate.plusworkflow.util.Json;
import com.suncode.autoupdate.server.client.UpdateServerClient;
import com.suncode.autoupdate.server.client.api.AvailablePatches;
import com.suncode.autoupdate.server.client.api.Patch;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginControl;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import com.suncode.plugin.framework.Version;
import com.suncode.plugin.framework.requirements.Requirement;
import com.suncode.plugin.framework.requirements.Requirements;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

public class PluginUpdate
extends AbstractComponentUpdate {
    private final Plugin plugin;
    private final PluginControl control;
    private final String channel;

    public PluginUpdate(Plugin plugin, PluginStore store, String channel, UpdateEngine engine, DownloadQueue downloadQueue, StateSummaryMapper summaryMapper, PluginControl control) {
        super(store, engine, downloadQueue, summaryMapper);
        this.plugin = plugin;
        this.control = control;
        this.channel = channel;
    }

    @Override
    protected boolean autoConfirm() {
        return true;
    }

    @Override
    protected boolean needsValidation() {
        return false;
    }

    @Override
    protected boolean persistentState() {
        return false;
    }

    @Override
    protected boolean validate(List<PendingPatch> patches, Downloads download) {
        return true;
    }

    @Override
    public String key() {
        return this.plugin.getKey();
    }

    @Override
    protected String getProjectName() {
        return this.key();
    }

    @Override
    protected String getProjectDisplayName() {
        return this.plugin.getName();
    }

    @Override
    protected String getChannelName() {
        return this.channel;
    }

    @Override
    protected String getVersion() {
        return this.plugin.getVersion();
    }

    @Override
    public Changelog getPendingChangelog() {
        return Changelog.none();
    }

    private Requirements readRequirements(String raw) {
        if (raw == null) {
            return Requirements.none();
        }
        Set requirements = (Set)Json.get().readValue(raw, (TypeReference)new TypeReference<Set<PluginPatchProperties.PluginRequirement>>(){});
        return Requirements.of((Collection)requirements.stream().map(req -> {
            boolean optional = !req.isMandatory();
            List<Version> versions = Arrays.asList(Version.parse((String)req.getVersion()));
            return new Requirement(req.getId(), versions, optional);
        }).collect(Collectors.toSet()));
    }

    @Override
    protected Patches getAvailablePatches(UpdateServerClient client) {
        AvailablePatches patches = client.updates().checkAll(this.getProjectName(), this.getChannelName(), this.getVersion());
        return new PluginUpdates(patches.getNewest(), patches.getNewer(), patches.getOlder(), this::validated);
    }

    private PluginUpdates.Validated validated(Patch patch) {
        Requirements requirements = this.readRequirements((String)patch.getProperties().get(PluginPatchProperties.REQUIREMENTS));
        PluginControl.Validation validation = this.control.validate(this.plugin, Version.parse((String)patch.getToVersion()), requirements);
        return new PluginUpdates.Validated(patch, new ValidationView(validation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean applyUpdates(List<PendingPatch> patches, Downloads download) {
        Preconditions.checkArgument((patches.size() == 1 ? 1 : 0) != 0);
        PendingPatch patch = patches.get(0);
        PluginStoreResource resource = download.patchArchive(patch);
        Date started = new Date();
        ImmutableMap params = ImmutableMap.of((Object)"PLUGINID", (Object)this.plugin.getKey(), (Object)"NEW_VERSION", (Object)patch.getToVersion(), (Object)"OLD_VERSION", (Object)this.plugin.getVersion(), (Object)"UPDATE_TYPE", (Object)"automatic");
        File temp = File.createTempFile(this.key(), ".update");
        try {
            try (InputStream inputStream = resource.getInputStream();
                 FileOutputStream outputStream = new FileOutputStream(temp);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            Exceptions.safe(() -> this.plugin.update(temp), e -> this.plugin.getVersion().equals(patch.getToVersion()));
            PluginUpdate.audit(true, (Map<String, Object>)params, started);
        }
        catch (Exception e2) {
            PluginUpdate.audit(false, (Map<String, Object>)params, started);
        }
        finally {
            temp.delete();
        }
        return false;
    }

    private static void audit(boolean success, Map<String, Object> params, Date started) {
        ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_PLUGIN).success(success).params(params).username(UserContext.current().getUser().getUserName()).started(started).build().log();
    }

    @Override
    protected void applyRollback(Rollback rollback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ComponentUpdate.ApplyResult apply(InputStream patch) {
        throw new UnsupportedOperationException();
    }

    @Component
    public static class Factory {
        private final PluginControl control;
        private final UpdateEngine engine;
        private final PluginStore store;
        private final DownloadQueue downloadQueue;
        private final StateSummaryMapper summaryMapper;

        public PluginUpdate releaseChannel(Plugin plugin) {
            return new PluginUpdate(plugin, this.store, "release", this.engine, this.downloadQueue, this.summaryMapper, this.control);
        }

        @ConstructorProperties(value={"control", "engine", "store", "downloadQueue", "summaryMapper"})
        @Autowired
        public Factory(PluginControl control, UpdateEngine engine, PluginStore store, DownloadQueue downloadQueue, StateSummaryMapper summaryMapper) {
            this.control = control;
            this.engine = engine;
            this.store = store;
            this.downloadQueue = downloadQueue;
            this.summaryMapper = summaryMapper;
        }
    }
}

