/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.engine;

import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdate;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdater;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.OrderComparator;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class Updates {
    private static final Logger log = LoggerFactory.getLogger(Updates.class);
    @Autowired
    private List<ComponentUpdater> updaters;
    private volatile Instant lastChecked;

    @Async
    public void checkAll() {
        Instant now = Instant.now();
        if (this.lastChecked == null || this.lastChecked.isBefore(now.minus(1L, ChronoUnit.MINUTES))) {
            this.lastChecked = now;
            this.updaters.stream().sorted(OrderComparator.INSTANCE).forEach(updater -> {
                for (ComponentUpdate component : updater.getComponents()) {
                    log.debug("Checking updates for component {}", (Object)component.key());
                    component.check();
                }
            });
        }
    }
}

